% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-all.R
\name{chk_all}
\alias{chk_all}
\alias{vld_all}
\title{Check All}
\usage{
chk_all(x, chk_fun, ..., x_name = NULL)

vld_all(x, vld_fun, ...)
}
\arguments{
\item{x}{The object to check.}

\item{chk_fun}{A chk_ function.}

\item{...}{Additional arguments.}

\item{x_name}{A string of the name of object x or NULL.}

\item{vld_fun}{A vld_ function.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks all elements using

\code{all(vapply(x, chk_fun, TRUE, ...))}
}
\section{Functions}{
\itemize{
\item \code{vld_all}: Validate All
}}

\examples{

# chk_all
chk_all(TRUE, chk_lgl)
# FIXME try(chk_all(1, chk_lgl))
chk_all(c(TRUE, NA), chk_lgl)

# vld_all
vld_all(c(TRUE, NA), vld_lgl)
}
\seealso{
Other chk_all: \code{\link{chk_all_equal}},
  \code{\link{chk_all_equivalent}},
  \code{\link{chk_all_identical}}
}
\concept{chk_all}
