% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CQUOTE.R
\name{CQUOTE}
\alias{CQUOTE}
\title{Paste Words or Numbers with Quatation Marks}
\usage{
CQUOTE(x, quote = NULL, blank = TRUE)
}
\arguments{
\item{x}{a character, numeric or factor vector.}

\item{quote}{whether to add quotation marks. 
Default is NULL, the function adds quotation 
marks to characters, not numbers. However, 
you can set it to TRUE or FALSE.}

\item{blank}{if \code{x} are characters, whether 
blank (i. e., "") is to be kept. Default is TRUE.}
}
\description{
This function simply pastes things together and 
message them on the screen. Suppose you use 
\code{x=readClipboard()} and get "a", "b", "c", 
then, \code{CQUOTE(x)} will message 
\code{c("a", "b", "c")} on the screen.
}
\examples{
\donttest{
a=letters[1: 5]
CQUOTE(a) # c("a", "b", "c", "d", "e")
b=1: 5
CQUOTE(b) # c(1, 2, 3, 4, 5)
CQUOTE(b, quote=TRUE) # c("1", "2", "3", "4", "5")
}
}
