% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmpt06.R
\docType{data}
\name{rmpt06_main}
\alias{rmpt06_main}
\alias{rmpt06_pre}
\alias{rmpt06_post}
\alias{rmpt06}
\title{\code{RMPT06} Table 1 (Default) Seriousness, Outcomes, Severity, Frequency with 95\% CI for Risk Management Plan.}
\format{
An object of class \code{chevron_t} of length 1.
}
\usage{
rmpt06_main(
  adam_db,
  arm_var = "ACTARM",
  lbl_overall = NULL,
  method = "clopper-pearson",
  conf_level = 0.95,
  show_diff = FALSE,
  ref_group = NULL,
  method_diff = "wald",
  conf_level_diff = 0.95,
  grade_groups = NULL,
  ...
)

rmpt06_pre(adam_db, ...)

rmpt06_post(tlg, prune_0 = FALSE, ...)

rmpt06
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{method}{(\code{string}) the method used to construct the confidence interval. See \code{\link[tern:estimate_proportion]{tern::estimate_proportion}}.}

\item{conf_level}{(\code{proportion}) the confidence level of the interval. See \code{\link[tern:estimate_proportion]{tern::estimate_proportion}}.}

\item{show_diff}{(\code{flag}) whether to show the difference of patient with at least one adverse event  between groups.}

\item{ref_group}{(\code{string}) the reference group for the difference.}

\item{method_diff}{(\code{string}) the method used to construct the confidence interval for the difference between groups.}

\item{conf_level_diff}{(\code{proportion}) the confidence level of the interval for the difference between groups.}

\item{grade_groups}{(\code{list}) the grade groups to be displayed.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
\code{RMPT06} Table 1 (Default) Seriousness, Outcomes, Severity, Frequency with 95\% CI for Risk Management Plan.
}
\section{Functions}{
\itemize{
\item \code{rmpt06_main()}: Main TLG function

\item \code{rmpt06_pre()}: Preprocessing

\item \code{rmpt06_post()}: Postprocessing

}}
\examples{
run(rmpt06, syn_data)
}
\keyword{datasets}
