% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_visualization.r
\name{radial_cheem_tour}
\alias{radial_cheem_tour}
\alias{radial_cheem_tour_subplots}
\title{Cheem tour; 1D manual tour on the selected attribution}
\usage{
radial_cheem_tour(
  cheem_ls,
  basis,
  manip_var,
  primary_obs = NULL,
  comparison_obs = NULL,
  do_add_pcp_segments = TRUE,
  pcp_shape = c(3, 142, 124),
  angle = 0.15,
  row_index = NULL,
  inc_var_nms = NULL,
  do_center_frame = TRUE,
  do_add_residual = FALSE
)

radial_cheem_tour_subplots(
  cheem_ls,
  basis,
  manip_var,
  primary_obs = NULL,
  comparison_obs = NULL,
  do_add_pcp_segments = TRUE,
  pcp_shape = c(3, 142, 124),
  angle = 0.15,
  row_index = NULL,
  inc_var_nms = NULL,
  do_center_frame = TRUE
)
}
\arguments{
\item{cheem_ls}{A return from \code{cheem_ls()}, a list of data frames.}

\item{basis}{A 1D projection basis, typically a return of
\code{basis_attr_df()}.}

\item{manip_var}{The , \emph{number} of the manipulation variable.}

\item{primary_obs}{The rownumber of the primary observation. Its local
attribution becomes the 1d projection basis, and the point it highlighted
as a dashed line. Defaults to NULL, no primary observation highlighted.}

\item{comparison_obs}{The rownumber of the comparison observation. Point
is highlighted as a dotted line. Defaults to NULL,
no comparison observation highlighted.}

\item{do_add_pcp_segments}{Logical, whether or not to add parallel coordinate
line segments to the basis display.}

\item{pcp_shape}{The number of the shape character to add. Expects
3, 142, or 124, '+', '|' in \code{plotly}, and '|' in \code{gganimate}, respectively.
Defaults to 3, '+' in either output.}

\item{angle}{The step size between interpolated frames, in radians.
Defaults to .15.}

\item{row_index}{Numeric index of selected observations.
Defaults to TRUE; 1:n.}

\item{inc_var_nms}{A vector of the names of the variables to include in the
projection.}

\item{do_center_frame}{Whether or not to scale by standard deviations away
from the mean within each frame or not.
Defaults to TRUE, helping to keep the animation centered.}

\item{do_add_residual}{Whether of not to add a facet with a fixed y on
residual. Doing so may cause issues with animation. Defaults to FALSE.}
}
\value{
ggtour (\code{ggplot2} object with frame info) animation frames of a
radial tour manipulating the contribution of a selected tour. Animated with
\verb{spinifex::animate_*} functions.
}
\description{
Create a linked \code{plotly}of the global data-
and attribution- spaces. Typically consumed directly by shiny app.
}
\examples{
library(cheem)
library(spinifex)

## Classification setup:
X    <- penguins_na.rm[, 1:4]
clas <- penguins_na.rm$species
Y    <- as.integer(clas)

## Model and tree SHAP explanation:
rf_fit  <- default_rf(X, Y)
shap_df <- attr_df_treeshap(rf_fit, X, noisy = FALSE)
this_ls <- cheem_ls(X, Y, class = clas,
                     model = rf_fit,
                     attr_df = shap_df)

## Basis & suggest manipulation var
bas <- basis_attr_df(shap_df, rownum = 1)
mv  <- manip_var_of_attr_df(shap_df, primary_obs = 1, comparison_obs = 2)

## Radial tour with ggplot facets & animate
ggt <- radial_cheem_tour(this_ls, basis = bas, manip_var = 1)
\donttest{
animate_plotly(ggt)
if(FALSE) ## or animate with gganimate
  animate_gganimate(ggt, render = gganimate::av_renderer())

## Radial tour using plotly::subplots, not compatible with gganimate.
ggt <- radial_cheem_tour_subplots(this_ls, basis = bas, manip_var = 1)
animate_plotly(ggt)
}


## Regression setup:
dat  <- amesHousing2018_NorthAmes
X    <- dat[, 1:9]
Y    <- dat$SalePrice
clas <- dat$SubclassMS

## Model and tree SHAP explanation:
rf_fit  <- default_rf(X, Y)
shap_df <- attr_df_treeshap(rf_fit, X, noisy = FALSE)
this_ls <- cheem_ls(X, Y, class = clas,
                     model = rf_fit,
                     attr_df = shap_df)

## Basis & suggest manipulation var
bas <- basis_attr_df(shap_df, rownum = 1)
mv  <- manip_var_of_attr_df(shap_df, primary_obs = 1, comparison_obs = 2)

## Radial tour with ggplot facets & animate
ggt <- radial_cheem_tour(this_ls, basis = bas, manip_var = 1)
\donttest{
animate_plotly(ggt)
if(FALSE) ## or animate with gganimate
  animate_gganimate(ggt, render = gganimate::av_renderer())

## Radial tour using plotly::subplots, not compatible with gganimate.
ggt <- radial_cheem_tour_subplots(this_ls, basis = bas, manip_var = 1)
animate_plotly(ggt)
}
}
\seealso{
Other cheem consumers: 
\code{\link{global_view}()},
\code{\link{run_app}()}
}
\concept{cheem consumers}
