% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integer.R
\name{check_integer}
\alias{check_integer}
\title{Check Integer}
\usage{
check_integer(x, coerce = FALSE, x_name = substitute(x),
  error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{coerce}{A flag indicating whether to coerce a numeric (dbl) whole number vector to an integer vector and drop attributes including names.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Checks if x is an integer vector with no attributes including names.
}
\examples{
check_integer(1, error = FALSE)
check_integer(1L, error = FALSE)
check_integer(1:2, error = FALSE)
}
\seealso{
\code{\link{check_int}}
}
