% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/length.R
\name{check_length}
\alias{check_length}
\title{Check Length}
\usage{
check_length(x, length = c(1L, .Machine$integer.max),
  x_name = substitute(x), error = TRUE)
}
\arguments{
\item{x}{The object to check.}

\item{length}{A count of the length or count range of the minimum and maximum length.}

\item{x_name}{A string of the name of the object.}

\item{error}{A flag indicating whether to throw an informative error or immediately generate an informative message if the check fails.}
}
\value{
An invisible copy of x (if it doesn't throw an error).
}
\description{
Check Length
}
\examples{
check_length(2)
check_length(character(0), length = 0)
check_length(NULL, error = FALSE)
check_length(list(), error = FALSE)
}
