% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkIntegerish.R
\name{checkIntegerish}
\alias{assertIntegerish}
\alias{assert_integerish}
\alias{checkIntegerish}
\alias{expect_integerish}
\alias{testIntegerish}
\alias{test_integerish}
\title{Check if an object is an integerish vector}
\usage{
checkIntegerish(x, tol = sqrt(.Machine$double.eps), lower = -Inf,
  upper = Inf, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL)

assertIntegerish(x, tol = sqrt(.Machine$double.eps), lower = -Inf,
  upper = Inf, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL,
  .var.name = vname(x), add = NULL)

assert_integerish(x, tol = sqrt(.Machine$double.eps), lower = -Inf,
  upper = Inf, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL,
  .var.name = vname(x), add = NULL)

testIntegerish(x, tol = sqrt(.Machine$double.eps), lower = -Inf,
  upper = Inf, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL)

test_integerish(x, tol = sqrt(.Machine$double.eps), lower = -Inf,
  upper = Inf, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL)

expect_integerish(x, tol = sqrt(.Machine$double.eps), lower = -Inf,
  upper = Inf, any.missing = TRUE, all.missing = TRUE, len = NULL,
  min.len = NULL, max.len = NULL, unique = FALSE, names = NULL,
  info = NULL, label = vname(x))
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{tol}{[\code{double(1)}]\cr
Numerical tolerance used to check whether a double or complex can be converted.
Default is \code{sqrt(.Machine$double.eps)}.}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{all.missing}{[\code{logical(1)}]\cr
Are vectors with only missing values allowed? Default is \code{TRUE}.}

\item{len}{[\code{integer(1)}]\cr
Exact expected length of \code{x}.}

\item{min.len}{[\code{integer(1)}]\cr
Minimal length of \code{x}.}

\item{max.len}{[\code{integer(1)}]\cr
Maximal length of \code{x}.}

\item{unique}{[\code{logical(1)}]\cr
Must all values be unique? Default is \code{FALSE}.}

\item{names}{[\code{character(1)}]\cr
Check for names. See \code{\link{checkNamed}} for possible values.
Default is \dQuote{any} which performs no check at all.
Note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[character(1)]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertIntegerish}/\code{assert_integerish}
 throws an error message, \code{testIntegerish}/\code{test_integerish}
 returns \code{FALSE},
 and \code{checkIntegerish} returns a string with the error message.
 The function \code{expect_integerish} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an object is an integerish vector
}
\details{
This function does not distinguish between
\code{NA}, \code{NA_integer_}, \code{NA_real_}, \code{NA_complex_}
\code{NA_character_} and \code{NaN}.
}
\examples{
testIntegerish(1L)
testIntegerish(1.)
testIntegerish(1:2, lower = 1L, upper = 2L, any.missing = FALSE)
}
\seealso{
Other basetypes: \code{\link{checkArray}},
  \code{\link{checkAtomic}}, \code{\link{checkCharacter}},
  \code{\link{checkComplex}}, \code{\link{checkDataFrame}},
  \code{\link{checkDataTable}},
  \code{\link{checkEnvironment}},
  \code{\link{checkFactor}}, \code{\link{checkFunction}},
  \code{\link{checkInteger}}, \code{\link{checkList}},
  \code{\link{checkLogical}}, \code{\link{checkMatrix}},
  \code{\link{checkNumeric}}, \code{\link{checkVector}}
}

