% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_spec.R
\name{task_spec}
\alias{task_spec}
\alias{install_task_spec}
\alias{custom_install_task_spec}
\alias{check_task_spec}
\alias{revdep_check_task_spec}
\title{Task specification}
\usage{
task_spec(alias = NULL, package_spec = NULL, env = NULL)

install_task_spec(type = getOption("pkgType"), INSTALL_opts = NULL, ...)

custom_install_task_spec(...)

check_task_spec(args = NULL, build_args = NULL, ...)

revdep_check_task_spec(revdep, ...)
}
\arguments{
\item{alias}{task alias which also serves as unique identifier of the task.}

\item{package_spec}{\code{\link[checked]{package_spec}} object}

\item{env}{environmental variables to be set in separate process running
specific task.}

\item{type}{character, indicating the type of package to download and
    install.  Will be \code{"source"} except on Windows and some macOS
    builds: see the section on \sQuote{Binary packages} for those.
  }

\item{INSTALL_opts}{
    an optional character vector of additional option(s) to be passed to
    \command{R CMD INSTALL} for a source package install.  E.g.,
    \code{c("--html", "--no-multiarch", "--no-test-load")}.

    Can also be a named list of character vectors to be used as
    additional options, with names the respective package names.
  }

\item{...}{parameters passed to downstream constructors}

\item{args}{Character vector of arguments to pass to \verb{R CMD check}. Pass each
argument as a single element of this character vector (do not use spaces to
delimit arguments like you would in the shell). For example, to skip
running of examples and tests, use \code{args = c("--no-examples", "--no-tests")} and not \code{args = "--no-examples --no-tests"}. (Note that
instead of the \code{--output} option you should use the \code{check_dir} argument,
because  \code{--output} cannot deal with spaces and other special characters on
Windows.)}

\item{build_args}{Character vector of arguments to pass to \verb{R CMD build}.
Pass each argument as a single element of this character vector (do not use
spaces to delimit arguments like you would in the shell). For example,
\code{build_args = c("--force", "--keep-empty-dirs")} is a correct usage and
\code{build_args = "--force --keep-empty-dirs"} is incorrect.}

\item{revdep}{character indicating whether the task specification describes
check associated with the development (new) or release (old) version of the
for which reverse dependency check is run.}
}
\description{
Create task specification list which consists of all the details required
to run specific task.
}
