% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sset_df.R
\name{sset_df}
\alias{sset_df}
\alias{sset_row}
\alias{sset_col}
\title{Fast functions for data frame subsetting}
\usage{
sset_df(x, i = NULL, j = NULL, keep_attrs = FALSE)

sset_row(x, i = NULL)

sset_col(x, j = NULL)
}
\arguments{
\item{x}{A \code{data.frame}.}

\item{i}{Rows - If \code{NULL} all rows are returned.}

\item{j}{Cols - If \code{NULL} all cols are returned.}

\item{keep_attrs}{Should all attributes (except for \code{names} and \code{row.names})
be kept as is? The default is \code{FALSE} which returns a plain data frame.}
}
\value{
A data frame subsetted on rows \code{i} and cols \code{j}.
}
\description{
These functions are for developers that need minimal overhead when
filtering on rows and/or cols.
}
\details{
If you are unsure which functions to use then it is recommended to use
\code{sset()}. These low-overhead helpers do not work well with data.tables
but should work well with basic data frames and basic tibbles.
}
