% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMOCfunc.R
\name{AMOCcrossover}
\alias{AMOCcrossover}
\title{Average crossover operator to produce offspring for AMOC problem}
\usage{
AMOCcrossover(mom, dad, p.range = NULL, minDist, lmax, N)
}
\arguments{
\item{mom}{Among two selected individuals, \code{mom} represents the selected
chromosome representation with lower fitness function value.}

\item{dad}{Among two selected individuals, \code{dad} represents the selected
chromosome representation with larger fitness function value.}

\item{p.range}{The default value is \code{NULL}. If there is no requirement
on model order selection, such an auxiliary argument is needed for \code{GA}
and \code{IslandGA} functions.}

\item{minDist}{The minimum length between two adjacent changepoints.}

\item{lmax}{The maximum possible length of the chromosome representation.}

\item{N}{The length of time series.}
}
\value{
The child chromosome that produced from \code{mom} and \code{dad} for
next generation.
}
\description{
In this crossover operator designed for AMOC problem, the new child is
produced by taking the average of the changepoint locations from \code{dad}
and \code{mom} and round to an integer. Note, every chromosome has at most
one candidate changepoint location.
}
