% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runlength.R
\name{runlength}
\alias{runlength}
\alias{runlength.cgrcusum}
\alias{runlength.bkcusum}
\alias{runlength.bercusum}
\title{Determine run length of a CUSUM chart}
\usage{
runlength(chart, h)

\method{runlength}{cgrcusum}(chart, h, ...)

\method{runlength}{bkcusum}(chart, h, ...)

\method{runlength}{bercusum}(chart, h, ...)
}
\arguments{
\item{chart}{a 'cgrcusum', 'bkcusum' or 'bercusum' chart}

\item{h}{control limit h to be used when determining the run length}

\item{...}{other parameters}
}
\value{
The run length of the chart with the given control limit.
}
\description{
This function can be used to calculate the run length of a 'cgrcusum', 'bkcusum'
or 'bercusum'
chart when using control limit h
}
\section{Methods (by class)}{
\itemize{
\item \code{cgrcusum}: Determine runlength of "cgrcusum" object

\item \code{bkcusum}: Determine runlength of "bkcusum" object

\item \code{bercusum}: Determine runlength of "bercusum" object
}}

\examples{
varsanalysis <- c("age", "sex", "BMI")
exprfitber <- as.formula(paste("(entrytime <= 365) & (censorid == 1)~",
                               paste(varsanalysis, collapse='+')))
surgerydat$instance <- surgerydat$Hosp_num
glmmodber <- glm(exprfitber, data = surgerydat, family = binomial(link = "logit"))
bercus <- bercusum(data = subset(surgerydat, Hosp_num == 14), glmmod = glmmodber,
                   followup = 100, theta = log(2))
runlength(bercus, h = 2)
}
\seealso{
Other utils: 
\code{\link{calc_risk}()},
\code{\link{exp_hazards}},
\code{\link{gen_arriv_times}()},
\code{\link{gen_surv_times}()}

Other utils: 
\code{\link{calc_risk}()},
\code{\link{exp_hazards}},
\code{\link{gen_arriv_times}()},
\code{\link{gen_surv_times}()}

Other utils: 
\code{\link{calc_risk}()},
\code{\link{exp_hazards}},
\code{\link{gen_arriv_times}()},
\code{\link{gen_surv_times}()}
}
\author{
Daniel Gomon
}
\concept{utils}
