% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgalPolygonWithHoles.R
\name{cgalPolygonWithHoles}
\alias{cgalPolygonWithHoles}
\title{R6 class to represent a CGAL polygon with holes}
\description{
R6 class to represent a CGAL polygon with holes.
}
\examples{

## ------------------------------------------------
## Method `cgalPolygonWithHoles$new`
## ------------------------------------------------

library(cgalPolygons)
pwh <- cgalPolygonWithHoles$new(
  squareWithHole[["outerSquare"]], list(squareWithHole[["innerSquare"]])
)
pwh

## ------------------------------------------------
## Method `cgalPolygonWithHoles$area`
## ------------------------------------------------

library(cgalPolygons)
pwh <- cgalPolygonWithHoles$new(
  squareWithHole[["outerSquare"]], list(squareWithHole[["innerSquare"]])
)
pwh$area() # should be 12

## ------------------------------------------------
## Method `cgalPolygonWithHoles$boundingBox`
## ------------------------------------------------

library(cgalPolygons)
pwh <- cgalPolygonWithHoles$new(
  squareWithHole[["outerSquare"]], list(squareWithHole[["innerSquare"]])
)
pwh$boundingBox()

## ------------------------------------------------
## Method `cgalPolygonWithHoles$convexParts`
## ------------------------------------------------

library(cgalPolygons)
pwh <- cgalPolygonWithHoles$new(
  squareWithHole[["outerSquare"]], list(squareWithHole[["innerSquare"]])
)
cxparts <- pwh$convexParts()
pwh$plot(list(), density = 10)
invisible(
  lapply(cxparts, function(cxpart) {
    polygon(cxpart, lwd = 2)
  })
)

## ------------------------------------------------
## Method `cgalPolygonWithHoles$intersection`
## ------------------------------------------------

library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles with a hole
plg1 <- cgalPolygonWithHoles$new(
  circle(-1, 0, 1.5), holes = list(circle(-1, 0, 0.8))
)
plg2 <- cgalPolygonWithHoles$new(
  circle(1, 0, 1.5), holes = list(circle(1, 0, 0.8))
)
# intersection
plgList <- plg1$intersection(plg2)
plg <- plgList[[1]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plot(
  NULL, xlim = c(-2.6, 2.6), ylim = c(-1.6, 1.6), asp = 1, 
  xlab = NA, ylab = NA, axes = FALSE
)
plg1$plot(list(lwd = 2), lwd = 2, density = 10, new = FALSE)
plg2$plot(list(lwd = 2), lwd = 2, density = 10, new = FALSE)
plg$plot(lwd = 4, col = "red", new = FALSE)
par(opar)

## ------------------------------------------------
## Method `cgalPolygonWithHoles$minkowskiSum`
## ------------------------------------------------

library(cgalPolygons)
plg1 <- cgalPolygonWithHoles$new(decagram)
plg2 <- cgalPolygonWithHoles$new(star)
minko <- plg1$minkowskiSum(plg2)
minko$plot(lwd = 2, col = "limegreen")

## ------------------------------------------------
## Method `cgalPolygonWithHoles$plot`
## ------------------------------------------------

library(cgalPolygons)
pwh <- cgalPolygonWithHoles$new(
  squareWithHole[["outerSquare"]], list(squareWithHole[["innerSquare"]])
)
pwh$plot(
  outerpars = list(lwd = 2), density = 10
)

## ------------------------------------------------
## Method `cgalPolygonWithHoles$subtract`
## ------------------------------------------------

library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles with a hole
plg1 <- cgalPolygonWithHoles$new(
  circle(-1, 0, 1.5), holes = list(circle(-1, 0, 0.8))
)
plg2 <- cgalPolygonWithHoles$new(
  circle(1, 0, 1.5), holes = list(circle(1, 0, 0.8))
)
# difference
plgList <- plg1$subtract(plg2)
# plot
opar <- par(mar = c(0, 0, 0, 0))
plot(
  NULL, xlim = c(-2.6, 2.6), ylim = c(-1.6, 1.6), asp = 1, 
  xlab = NA, ylab = NA, axes = FALSE
)
plgList[[1]]$plot(lwd = 4, col = "red", new = FALSE)
plgList[[2]]$plot(lwd = 4, col = "red", new = FALSE)
par(opar)

## ------------------------------------------------
## Method `cgalPolygonWithHoles$symdiff`
## ------------------------------------------------

library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles with a hole
plg1 <- cgalPolygonWithHoles$new(
  circle(-1, 0, 1.5), holes = list(circle(-1, 0, 0.8))
)
plg2 <- cgalPolygonWithHoles$new(
  circle(1, 0, 1.5), holes = list(circle(1, 0, 0.8))
)
# symmetric difference
plgList <- plg1$symdiff(plg2)
plg <- plgList[[1L]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plg$plot(list(lwd = 4, col = "red"), lwd = 4, col = "white")
par(opar)

## ------------------------------------------------
## Method `cgalPolygonWithHoles$union`
## ------------------------------------------------

library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles with a hole
plg1 <- cgalPolygonWithHoles$new(
  circle(-1, 0, 1.5), holes = list(circle(-1, 0, 0.8))
)
plg2 <- cgalPolygonWithHoles$new(
  circle(1, 0, 1.5), holes = list(circle(1, 0, 0.8))
)
# union
plgList <- plg1$union(plg2)
plg <- plgList[[1]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plg$plot(list(lwd = 4, col = "red"), lwd = 4, col = "white")
par(opar)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-cgalPolygonWithHoles-new}{\code{cgalPolygonWithHoles$new()}}
\item \href{#method-cgalPolygonWithHoles-area}{\code{cgalPolygonWithHoles$area()}}
\item \href{#method-cgalPolygonWithHoles-boundingBox}{\code{cgalPolygonWithHoles$boundingBox()}}
\item \href{#method-cgalPolygonWithHoles-convexParts}{\code{cgalPolygonWithHoles$convexParts()}}
\item \href{#method-cgalPolygonWithHoles-getVertices}{\code{cgalPolygonWithHoles$getVertices()}}
\item \href{#method-cgalPolygonWithHoles-intersection}{\code{cgalPolygonWithHoles$intersection()}}
\item \href{#method-cgalPolygonWithHoles-minkowskiSum}{\code{cgalPolygonWithHoles$minkowskiSum()}}
\item \href{#method-cgalPolygonWithHoles-plot}{\code{cgalPolygonWithHoles$plot()}}
\item \href{#method-cgalPolygonWithHoles-print}{\code{cgalPolygonWithHoles$print()}}
\item \href{#method-cgalPolygonWithHoles-subtract}{\code{cgalPolygonWithHoles$subtract()}}
\item \href{#method-cgalPolygonWithHoles-symdiff}{\code{cgalPolygonWithHoles$symdiff()}}
\item \href{#method-cgalPolygonWithHoles-union}{\code{cgalPolygonWithHoles$union()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygonWithHoles-new"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygonWithHoles-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{cgalpolygonWithHoles} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygonWithHoles$new(outerVertices, holes = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{outerVertices}}{a numeric matrix with two columns, the vertices 
of the outer polygon}

\item{\code{holes}}{a list of numeric matrices, each representing the vertices 
of a hole; an empty list is allowed}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{cgalPolygonWithHoles} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
pwh <- cgalPolygonWithHoles$new(
  squareWithHole[["outerSquare"]], list(squareWithHole[["innerSquare"]])
)
pwh
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygonWithHoles-area"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygonWithHoles-area}{}}}
\subsection{Method \code{area()}}{
Area of the polygon with holes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygonWithHoles$area()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A positive number, the area of the polygon.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
pwh <- cgalPolygonWithHoles$new(
  squareWithHole[["outerSquare"]], list(squareWithHole[["innerSquare"]])
)
pwh$area() # should be 12
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygonWithHoles-boundingBox"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygonWithHoles-boundingBox}{}}}
\subsection{Method \code{boundingBox()}}{
Bounding box of the polygon with holes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygonWithHoles$boundingBox()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 2x2 matrix giving the lower corner of the bounding box in its 
  first row and the upper corner in its second row.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
pwh <- cgalPolygonWithHoles$new(
  squareWithHole[["outerSquare"]], list(squareWithHole[["innerSquare"]])
)
pwh$boundingBox()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygonWithHoles-convexParts"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygonWithHoles-convexParts}{}}}
\subsection{Method \code{convexParts()}}{
Decomposition into convex parts of the polygon with holes. 
  The outer polygon as well as the holes must be simple.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygonWithHoles$convexParts(method = "triangle")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{the method used: \code{"triangle"} or \code{"vertical"}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of matrices; each matrix has two columns and represents 
  a convex polygon.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
pwh <- cgalPolygonWithHoles$new(
  squareWithHole[["outerSquare"]], list(squareWithHole[["innerSquare"]])
)
cxparts <- pwh$convexParts()
pwh$plot(list(), density = 10)
invisible(
  lapply(cxparts, function(cxpart) {
    polygon(cxpart, lwd = 2)
  })
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygonWithHoles-getVertices"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygonWithHoles-getVertices}{}}}
\subsection{Method \code{getVertices()}}{
Get the vertices of the polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygonWithHoles$getVertices()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A named list with two fields: \code{"outer"}, the vertices of 
  the outer polygon in a matrix, and \code{"holes"}, the vertices of 
  the holes in a list of matrices.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygonWithHoles-intersection"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygonWithHoles-intersection}{}}}
\subsection{Method \code{intersection()}}{
Intersection of the polygon with another polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygonWithHoles$intersection(plg2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plg2}}{a \code{cgalPolygon} object or a \code{cgalPolygonWithHoles} 
object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list whose each element is either a \code{cgalPolygon} object
  or a \code{cgalPolygonWithHoles} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles with a hole
plg1 <- cgalPolygonWithHoles$new(
  circle(-1, 0, 1.5), holes = list(circle(-1, 0, 0.8))
)
plg2 <- cgalPolygonWithHoles$new(
  circle(1, 0, 1.5), holes = list(circle(1, 0, 0.8))
)
# intersection
plgList <- plg1$intersection(plg2)
plg <- plgList[[1]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plot(
  NULL, xlim = c(-2.6, 2.6), ylim = c(-1.6, 1.6), asp = 1, 
  xlab = NA, ylab = NA, axes = FALSE
)
plg1$plot(list(lwd = 2), lwd = 2, density = 10, new = FALSE)
plg2$plot(list(lwd = 2), lwd = 2, density = 10, new = FALSE)
plg$plot(lwd = 4, col = "red", new = FALSE)
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygonWithHoles-minkowskiSum"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygonWithHoles-minkowskiSum}{}}}
\subsection{Method \code{minkowskiSum()}}{
Minkowski sum of the polygon and another polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygonWithHoles$minkowskiSum(plg2, method = "convolution")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plg2}}{a \code{cgalPolygon} object or a \code{cgalPolygonWithHoles} 
object, the polygon to add to the reference polygon}

\item{\code{method}}{the method used: \code{"convolution"}, \code{"triangle"}, 
\code{"vertical"} or \code{"optimal"} (the method should not change 
the result)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Either a \code{cgalPolygonWithHoles} object, or, in the case if 
  there is no hole in the Minkowski sum, a \code{cgalPolygon} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
plg1 <- cgalPolygonWithHoles$new(decagram)
plg2 <- cgalPolygonWithHoles$new(star)
minko <- plg1$minkowskiSum(plg2)
minko$plot(lwd = 2, col = "limegreen")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygonWithHoles-plot"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygonWithHoles-plot}{}}}
\subsection{Method \code{plot()}}{
Plot the polygon with holes.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygonWithHoles$plot(
  outerpars = list(),
  ...,
  new = TRUE,
  outerfirst = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{outerpars}}{named list of arguments passed to 
\code{\link[graphics]{polygon}} for the outer polygon}

\item{\code{...}}{arguments passed to \code{\link[graphics]{polygon}} for the 
holes}

\item{\code{new}}{Boolean, whether to create a new plot}

\item{\code{outerfirst}}{Boolean, whether to print the outer polygon first}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No returned value, called for side-effect.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
pwh <- cgalPolygonWithHoles$new(
  squareWithHole[["outerSquare"]], list(squareWithHole[["innerSquare"]])
)
pwh$plot(
  outerpars = list(lwd = 2), density = 10
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygonWithHoles-print"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygonWithHoles-print}{}}}
\subsection{Method \code{print()}}{
Print the \code{cgalPolygonWithHoles} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygonWithHoles$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No value, just prints some information about the polygon.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygonWithHoles-subtract"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygonWithHoles-subtract}{}}}
\subsection{Method \code{subtract()}}{
Difference between the polygon and another polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygonWithHoles$subtract(plg2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plg2}}{a \code{cgalPolygon} object or a \code{cgalPolygonWithHoles} 
object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list whose each element is either a \code{cgalPolygon} object
  or a \code{cgalPolygonWithHoles} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles with a hole
plg1 <- cgalPolygonWithHoles$new(
  circle(-1, 0, 1.5), holes = list(circle(-1, 0, 0.8))
)
plg2 <- cgalPolygonWithHoles$new(
  circle(1, 0, 1.5), holes = list(circle(1, 0, 0.8))
)
# difference
plgList <- plg1$subtract(plg2)
# plot
opar <- par(mar = c(0, 0, 0, 0))
plot(
  NULL, xlim = c(-2.6, 2.6), ylim = c(-1.6, 1.6), asp = 1, 
  xlab = NA, ylab = NA, axes = FALSE
)
plgList[[1]]$plot(lwd = 4, col = "red", new = FALSE)
plgList[[2]]$plot(lwd = 4, col = "red", new = FALSE)
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygonWithHoles-symdiff"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygonWithHoles-symdiff}{}}}
\subsection{Method \code{symdiff()}}{
Symmetric difference of the polygon and another polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygonWithHoles$symdiff(plg2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plg2}}{a \code{cgalPolygon} object or a \code{cgalPolygonWithHoles} 
object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list whose each element is either a \code{cgalPolygon} object
  or a \code{cgalPolygonWithHoles} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles with a hole
plg1 <- cgalPolygonWithHoles$new(
  circle(-1, 0, 1.5), holes = list(circle(-1, 0, 0.8))
)
plg2 <- cgalPolygonWithHoles$new(
  circle(1, 0, 1.5), holes = list(circle(1, 0, 0.8))
)
# symmetric difference
plgList <- plg1$symdiff(plg2)
plg <- plgList[[1L]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plg$plot(list(lwd = 4, col = "red"), lwd = 4, col = "white")
par(opar)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cgalPolygonWithHoles-union"></a>}}
\if{latex}{\out{\hypertarget{method-cgalPolygonWithHoles-union}{}}}
\subsection{Method \code{union()}}{
Union of the polygon with another polygon.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{cgalPolygonWithHoles$union(plg2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plg2}}{a \code{cgalPolygon} object or a \code{cgalPolygonWithHoles} 
object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list whose each element is either a \code{cgalPolygon} object
  or a \code{cgalPolygonWithHoles} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(cgalPolygons)
# function creating a circle
circle <- function(x, y, r) {
  t <- seq(0, 2, length.out = 100)[-1L]
  t(c(x, y) + r * rbind(cospi(t), sinpi(t)))
}
# take two circles with a hole
plg1 <- cgalPolygonWithHoles$new(
  circle(-1, 0, 1.5), holes = list(circle(-1, 0, 0.8))
)
plg2 <- cgalPolygonWithHoles$new(
  circle(1, 0, 1.5), holes = list(circle(1, 0, 0.8))
)
# union
plgList <- plg1$union(plg2)
plg <- plgList[[1]]
# plot
opar <- par(mar = c(0, 0, 0, 0))
plg$plot(list(lwd = 4, col = "red"), lwd = 4, col = "white")
par(opar)
}
\if{html}{\out{</div>}}

}

}
}
