% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_center.R
\name{mean_center}
\alias{mean_center}
\title{Mean Center}
\usage{
mean_center(x, group = NULL, weight = NULL)
}
\arguments{
\item{x}{Input POINT or POLYGON simple features}

\item{group}{name of character column specifying groups
to calculate individual mean centers for}

\item{weight}{name of numeric weight column specifying an
individual point's contribution to the mean center}
}
\value{
An sf object with a mean center for each group
}
\description{
Mean center calculates the geographic average center.
One can specify the groups to calculate individual centers
for groups and weights for each individual point. It is
analagous to the \href{https://pro.arcgis.com/en/pro-app/latest/tool-reference/spatial-statistics/mean-center.htm}{ArcGIS Pro Mean Center}
tool.

If \code{st_is_longlat(x)}, mean center is calculated assuming a
spherical Earth. Projected data is calculated assuming a
"flat" Earth.
}
\examples{
df <- data.frame(
  lon = c(20, 50, 30, 80, 10),
  lat = c(25, 70, 30, 50, 30),
  grp = c("a", "b", "a", "b", "a"),
  wt = c(1, 5, 1, 3, 2)
)
x <- sf::st_as_sf(df, coords = c("lon", "lat"), crs = 4326)
mean_center(x, group = "grp", weight = "wt")
}
