% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partykit.R
\name{survival_prob_partykit}
\alias{survival_prob_partykit}
\title{A wrapper for survival probabilities with partykit models}
\usage{
survival_prob_partykit(
  object,
  new_data,
  eval_time,
  time = deprecated(),
  output = "surv"
)
}
\arguments{
\item{object}{A parsnip \code{model_fit} object resulting from
\link[parsnip:details_decision_tree_partykit]{decision_tree() with engine = "partykit"} or
\link[parsnip:details_rand_forest_partykit]{rand_forest() with engine = "partykit"}.}

\item{new_data}{A data frame to be predicted.}

\item{eval_time}{A vector of times to predict the survival probability.}

\item{time}{Deprecated in favor of \code{eval_time}. A vector of times to predict the survival probability.}

\item{output}{Type of output. Can be either \code{"surv"} or \code{"haz"}.}
}
\value{
A tibble with a list column of nested tibbles.
}
\description{
A wrapper for survival probabilities with partykit models
}
\examples{
\dontshow{if (rlang::is_installed(c("partykit", "coin"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tree <- decision_tree() \%>\%
  set_mode("censored regression") \%>\%
  set_engine("partykit") \%>\%
  fit(Surv(time, status) ~ age + ph.ecog, data = lung)
survival_prob_partykit(tree, lung[1:3, ], eval_time = 100)
forest <- rand_forest() \%>\%
  set_mode("censored regression") \%>\%
  set_engine("partykit") \%>\%
  fit(Surv(time, status) ~ age + ph.ecog, data = lung)
survival_prob_partykit(forest, lung[1:3, ], eval_time = 100)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
