# Add labels to categorical variables of emigration datasets
#' @keywords internal
add_labels_emigration <- function(arrw,
                                   year = parent.frame()$year,
                                   lang = 'pt'){

  # check languate input
  checkmate::assert_string(lang, pattern = 'pt', na.ok = TRUE)

  # names of columns present in the data
  cols <- names(arrw)

  ### YEAR 2010
  if(year == 2010 & lang == 'pt'){


    # urban vs rural
    if ('V1006' %in% cols) {
      arrw <- arrw |> mutate(V1006 = case_when(
        V1006 == '1' ~'Urbana',
        V1006 == '2' ~'Rural'))
    }

    # sex of emmigrant
    if ('V0303' %in% cols) {
      arrw <- arrw |> mutate(V0303 = case_when(
        V0303 == '1' ~ 'Masculino',
        V0303 == '2' ~ 'Feminino',
        V0303==  '9' ~ 'Ignorado'))
    }

    # census tract type
    if ('V1005' %in% cols) {
      arrw <- arrw |> mutate(V1005 = case_when(
        V1005 == '1' ~ paste0('\u00c1rea urbanizada'),
        V1005 == '2' ~ paste0('\u00c1rea n\u00e3o urbanizada'),
        V1005 == '3' ~ paste0('\u00c1rea urbanizada isolada'),
        V1005 == '4' ~ paste0('\u00c1rea rural de extens\u00e3o urbana'),
        V1005 == '5' ~ 'Aglomerado rural (povoado)',
        V1005 == '6' ~ paste0('Aglomerado rural (n\u00facleo)'),
        V1005 == '7' ~ 'Aglomerado rural (outros)',
        V1005 == '8' ~ paste0('\u00c1rea rural exclusive aglomerado rural')))
    }

    # country of residence
    if ('V3061' %in% cols) {
      arrw <- arrw |> mutate(V3061 = case_when(
        V3061 == '8000710' ~ paste0('\u00c1frica do SUL'),
        V3061 == '8000024' ~ 'Angola',
        V3061 == '8000012' ~ paste0('Arg\u00e9lia'),
        V3061 == '8000204' ~ 'Benin',
        V3061 == '8000072' ~ 'Botswana',
        V3061 == '8000854' ~ 'Burkina Fasso',
        V3061 == '8000108' ~ 'Burundi',
        V3061 == '8000132' ~ 'Cabo Verde',
        V3061 == '8000120' ~ paste0('Camar\u00f5es'),
        V3061 == '8000148' ~ 'Chade',
        V3061 == '8000174' ~ 'Comores',
        V3061 == '8000178' ~ 'Congo',
        V3061 == '8000384' ~ 'Costa do Marfim',
        V3061 == '8000262' ~ 'Djibuti',
        V3061 == '8000818' ~ 'Egito',
        V3061 == '8000232' ~ paste0('Eritr\u00e9ia'),
        V3061 == '8000231' ~ paste0('Eti\u00f3pia'),
        V3061 == '8000266' ~ paste0('Gab\u00e3o'),
        V3061 == '8000270' ~ paste0('G\u00e2mbia'),
        V3061 == '8000288' ~ paste0('Gana'),
        V3061 == '8000324' ~ paste0('Guin\u00e9'),
        V3061 == '8000624' ~ paste0('Guin\u00e9 Bissau'),
        V3061 == '8000226' ~ paste0('Guin\u00e9 Equatorial'),
        V3061 == '8000426' ~ 'Lesoto',
        V3061 == '8000430' ~ paste0('Lib\u00e9ria'),
        V3061 == '8000434' ~ paste0('L\u00edbia'),
        V3061 == '8000450' ~ 'Madagascar',
        V3061 == '8000454' ~ 'Malawi',
        V3061 == '8000466' ~ 'Mali',
        V3061 == '8000504' ~ 'Marrocos',
        V3061 == '8000480' ~ paste0('Maur\u00edcio'),
        V3061 == '8000478' ~ paste0('Maurit\u00e2nia'),
        V3061 == '8000508' ~ paste0('Mo\u00e7ambique'),
        V3061 == '8000516' ~ paste0('Nam\u00edbia'),
        V3061 == '8000562' ~ 'Niger',
        V3061 == '8000566' ~ paste0('Nig\u00e9ria'),
        V3061 == '8000404' ~ paste0('Qu\u00eania'),
        V3061 == '8000140' ~ paste0('Rep\u00fablica Centro Africana'),
        V3061 == '8000180' ~ paste0('Rep\u00fablica Democr\u00e1tica do Congo'),
        V3061 == '8000646' ~ 'Ruanda',
        V3061 == '8000678' ~ paste0('S\u00e3o Tom\u00e9 e Pr\u00edncipe'),
        V3061 == '8000686' ~ 'Senegal',
        V3061 == '8000694' ~ 'Serra Leoa',
        V3061 == '8000690' ~ 'Seychelles',
        V3061 == '8000706' ~ paste0('Som\u00e1lia'),
        V3061 == '8000748' ~ paste0('Suazil\u00e2ndia'),
        V3061 == '8000736' ~ paste0('Sud\u00e3o'),
        V3061 == '8000834' ~ paste0('Tanz\u00e2nia'),
        V3061 == '8000768' ~ 'Togo',
        V3061 == '8000788' ~ paste0('Tun\u00edsia'),
        V3061 == '8000800' ~ paste0('Uganda'),
        V3061 == '8000894' ~ paste0('Z\u00e2mbia'),
        V3061 == '8000716' ~ paste0('Zimbabue'),
        V3061 == '8000028' ~ paste0('Ant\u00edgua e Barbuda'),
        V3061 == '8000032' ~ 'Argentina',
        V3061 == '8000044' ~ 'Bahamas',
        V3061 == '8000052' ~ 'Barbados',
        V3061 == '8000084' ~ 'Belize',
        V3061 == '8000068' ~ paste0('Bol\u00edvia'),
        V3061 == '8000124' ~ paste0('Canad\u00e1'),
        V3061 == '8000152' ~ paste0('Chile'),
        V3061 == '8000170' ~ paste0('Col\u00f4mbia'),
        V3061 == '8000188' ~ 'Costa Rica',
        V3061 == '8000192' ~ 'Cuba',
        V3061 == '8000212' ~ 'Dominica',
        V3061 == '8000222' ~ 'El Salvador',
        V3061 == '8000218' ~ 'Equador',
        V3061 == '8000840' ~ 'Estados Unidos',
        V3061 == '8000308' ~ 'Granada',
        V3061 == '8000320' ~ 'Guatemala',
        V3061 == '8000328' ~ 'Guiana',
        V3061 == '8000254' ~ 'Guiana Francesa',
        V3061 == '8000332' ~ 'Haiti',
        V3061 == '8000340' ~ 'Honduras',
        V3061 == '8000388' ~ 'Jamaica',
        V3061 == '8000484' ~ paste0('M\u00e9xico'),
        V3061 == '8000558' ~ paste0('Nicar\u00e1gua'),
        V3061 == '8000591' ~ paste0('Panam\u00e1'),
        V3061 == '8000600' ~ paste0('Paraguai'),
        V3061 == '8000604' ~ paste0('Peru'),
        V3061 == '8000214' ~ paste0('Rep\u00fablica Dominicana'),
        V3061 == '8000662' ~ paste0('Santa L\u00facia'),
        V3061 == '8000659' ~ paste0('S\u00e3o Crist\u00f3v\u00e3o e Nevis'),
        V3061 == '8000670' ~ 'Sao Vicente e Granadinas',
        V3061 == '8000740' ~ 'Suriname',
        V3061 == '8000780' ~ 'Trinidad e Tobago',
        V3061 == '8000858' ~ 'Uruguai',
        V3061 == '8000862' ~ 'Venezuela',
        V3061 == '8000004' ~ paste0('Afeganist\u00e3o'),
        V3061 == '8000682' ~ paste0('Ar\u00e1bia Saudita'),
        V3061 == '8000051' ~ paste0('Arm\u00eania'),
        V3061 == '8000031' ~ paste0('Azerbaidj\u00e3o'),
        V3061 == '8000048' ~ 'Bahrein',
        V3061 == '8000050' ~ 'Bangladesh',
        V3061 == '8000096' ~ 'Brunei Darussalan',
        V3061 == '8000064' ~ paste0('But\u00e3o'),
        V3061 == '8000116' ~ 'Camboja',
        V3061 == '8000398' ~ paste0('Casaquist\u00e3o'),
        V3061 == '8000634' ~ 'Catar',
        V3061 == '8000156' ~ 'China',
        V3061 == '8000196' ~ 'Chipre',
        V3061 == '8000702' ~ 'Cingapura',
        V3061 == '8000784' ~ paste0('Emirados \u00c1rabes Unidos'),
        V3061 == '8000608' ~ paste0('Filipinas'),
        V3061 == '8000268' ~ paste0('Ge\u00f3rgia'),
        V3061 == '8000887' ~ paste0('I\u00eamen'),
        V3061 == '8000356' ~ paste0('\u00cdndia'),
        V3061 == '8000360' ~ paste0('Indon\u00e9sia'),
        V3061 == '8000364' ~ paste0('Ir\u00e3'),
        V3061 == '8000368' ~ paste0('Iraque'),
        V3061 == '8000376' ~ paste0('Israel'),
        V3061 == '8000392' ~ paste0('Jap\u00e3o'),
        V3061 == '8000400' ~ paste0('Jord\u00e2nia'),
        V3061 == '8000414' ~ paste0('Kuwait'),
        V3061 == '8000422' ~ paste0('L\u00edbano'),
        V3061 == '8000458' ~ paste0('Mal\u00e1sia'),
        V3061 == '8000462' ~ 'Maldivas',
        V3061 == '8000104' ~ 'Mianmar',
        V3061 == '8000496' ~ paste0('Mong\u00f3lia'),
        V3061 == '8000524' ~ 'Nepal',
        V3061 == '8000512' ~ 'Oman',
        V3061 == '8000586' ~ paste0('Paquist\u00e3o'),
        V3061 == '8000417' ~ paste0('Quirguist\u00e3o'),
        V3061 == '8000410' ~ paste0('Rep\u00fablica da Coreia'),
        V3061 == '8000418' ~ paste0('Rep\u00fablica Democr\u00e1tica Popular do Laos'),
        V3061 == '8000408' ~ paste0('Rep\u00fablica Popular Democr\u00e1tica da Coreia'),
        V3061 == '8000760' ~ paste0('S\u00edria'),
        V3061 == '8000144' ~ paste0('Sri Lanka'),
        V3061 == '8000762' ~ paste0('Tadjiquist\u00e3o'),
        V3061 == '8000764' ~ paste0('Tail\u00e2ndia'),
        V3061 == '8000626' ~ paste0('Timor Leste'),
        V3061 == '8000795' ~ paste0('Turcomenist\u00e3o'),
        V3061 == '8000792' ~ paste0('Turquia'),
        V3061 == '8000860' ~ paste0('Uzbequist\u00e3o'),
        V3061 == '8000704' ~ paste0('Vietn\u00e3'),
        V3061 == '8000008' ~ paste0('Alb\u00e2nia'),
        V3061 == '8000276' ~ paste0('Alemanha'),
        V3061 == '8000020' ~ paste0('Andorra'),
        V3061 == '8000040' ~ paste0('\u00c1ustria'),
        V3061 == '8000112' ~ paste0('Belarus'),
        V3061 == '8000056' ~ paste0('B\u00e9lgica'),
        V3061 == '8000070' ~ paste0('B\u00f3snia e Herzegovina'),
        V3061 == '8000100' ~ paste0('Bulg\u00e1ria'),
        V3061 == '8000191' ~ paste0('Cro\u00e1cia'),
        V3061 == '8000208' ~ paste0('Dinamarca'),
        V3061 == '8000826' ~ paste0('Esc\u00f3cia'),
        V3061 == '8000703' ~ paste0('Eslov\u00e1quia'),
        V3061 == '8000705' ~ paste0('Eslov\u00eania'),
        V3061 == '8000724' ~ paste0('Espanha'),
        V3061 == '8000233' ~ paste0('Est\u00f4nia'),
        V3061 == '8000246' ~ paste0('Finl\u00e2ndia'),
        V3061 == '8000250' ~ paste0('Fran\u00e7a'),
        V3061 == '8000300' ~ paste0('Gr\u00e9cia'),
        V3061 == '8000528' ~ 'Holanda',
        V3061 == '8000348' ~ 'Hungria',
        V3061 == '8000826' ~ 'Inglaterra',
        V3061 == '8000372' ~ 'Irlanda',
        V3061 == '8000826' ~ 'Irlanda do Norte',
        V3061 == '8000352' ~ paste0('Isl\u00e2ndia'),
        V3061 == '8000380' ~ paste0('It\u00e1lia'),
        V3061 == '8000428' ~ paste0('Let\u00f4nia'),
        V3061 == '8000438' ~ paste0('Liechtenstein'),
        V3061 == '8000440' ~ paste0('Litu\u00e2nia'),
        V3061 == '8000442' ~ paste0('Luxemburgo'),
        V3061 == '8000807' ~ paste0('Maced\u00f4nia'),
        V3061 == '8000470' ~ paste0('Malta'),
        V3061 == '8000492' ~ paste0('M\u00f4naco'),
        V3061 == '8000499' ~ 'Montenegro',
        V3061 == '8000578' ~ 'Noruega',
        V3061 == '8000826' ~ paste0('Pa\u00eds de gales'),
        V3061 == '8000616' ~ paste0('Pol\u00f4nia'),
        V3061 == '8000620' ~ paste0('Portugal'),
        V3061 == '8000826' ~ paste0('Reino Unido'),
        V3061 == '8000498' ~ paste0('Rep\u00fablica da Moldavia'),
        V3061 == '8000203' ~ paste0('Rep\u00fablica Tcheca'),
        V3061 == '8000642' ~ paste0('Rom\u00eania'),
        V3061 == '8000643' ~ paste0('R\u00fassia'),
        V3061 == '8000674' ~ paste0('San Marino'),
        V3061 == '8000688' ~ paste0('S\u00e9rvia'),
        V3061 == '8000752' ~ paste0('Su\u00e9cia'),
        V3061 == '8000756' ~ paste0('Su\u00ed\u00e7a'),
        V3061 == '8000804' ~ paste0('Ucr\u00e2nia'),
        V3061 == '8000336' ~ paste0('Vaticano'),
        V3061 == '8000036' ~ paste0('Austr\u00e1lia'),
        V3061 == '8000583' ~ paste0('Federa\u00e7\u00e3o dos Estados da Micron\u00e9sia'),
        V3061 == '8000242' ~ 'Fiji',
        V3061 == '8000584' ~ 'Ilhas Marshall',
        V3061 == '8000090' ~ paste0('Ilhas Salom\u00e3o'),
        V3061 == '8000296' ~ 'Kiribati',
        V3061 == '8000520' ~ 'Nauru',
        V3061 == '8000554' ~ paste0('Nova Zel\u00e2ndia'),
        V3061 == '8000585' ~ 'Palau',
        V3061 == '8000598' ~ paste0('Papua Nova Guin\u00e9'),
        V3061 == '8000882' ~ 'Samoa',
        V3061 == '8000776' ~ 'Tonga',
        V3061 == '8000798' ~ 'Tuvalu',
        V3061 == '8000548' ~ 'Vanuatu',
        V3061 == '8000998' ~ 'Ignorado',
        V3061 == '8000999' ~ paste0('N\u00e3o sabia pa\u00eds estrangeiro')))
    }
  }

  return(arrw)
}
