% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudobulk.R
\name{pseudobulk_id}
\alias{pseudobulk_id}
\title{Generate unique IDs to identify your pseudobulks.}
\usage{
pseudobulk_id(factor_df)
}
\arguments{
\item{factor_df}{Data frame where each column helps to identify a pseudobulk.
Each row in factor_df corresponds to a single cell in your raw count matrix.
Typical columns of factor_df are for example patient, treatment and cell type -- anything
that uniquely identifies a replicate.}
}
\value{
Factor with syntactically valid and unique IDs.
}
\description{
This function generates unique IDs that are valid colnames as well.
Use these IDs in function pseudobulk.
}
\details{
Wraps \link[base]{make.names} to generate syntactically valid IDs.
Use these IDs in the \link[cellpypes]{pseudobulk} function.
Note that this function combines all columns in factor_df, so only include
the columns that uniquely identify replicates.
Cells from the same experimental unit
}
\examples{
# Create pseudobulk counts and coldata for DESeq2: 
coldata <- data.frame(
  celltype = rep(c("X+Y-", "X+Y+", "X-Y+", "X-Y-"),
                 each = nrow(simulated_umis$embed)/4), # 4 cell types
  patient  = c("3", "500.", "*5", "/")
)
coldata$pseudobulk_id <- pseudobulk_id(coldata)
counts <- pseudobulk(simulated_umis$raw, coldata$pseudobulk_id)
# Use counts/coldata as input for DESeqDataSetFromMatrix (DESeq2).
}
