% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_bulk.R
\name{simulate_bulk}
\alias{simulate_bulk}
\title{Simulate pseudo-bulk RNA-Seq}
\usage{
simulate_bulk(
  object,
  samples,
  subclass,
  times = 1,
  method = c("dirichlet", "unif"),
  alpha = 1
)
}
\arguments{
\item{object}{Either a 'cellMarkers' class object, or a single cell count
matrix with genes in rows and cells in columns, with rownames representing
gene IDs/symbols. The matrix can be a sparse matrix or DelayedMatrix.}

\item{samples}{An integer matrix of cell counts with samples in rows and
columns for each cell subclass in \code{object}. This can be generated using
\code{\link[=generate_samples]{generate_samples()}}.}

\item{subclass}{Vector of cell subclasses matching the columns in \code{object}.
Only used if \code{object} is a single cell count matrix.}

\item{times}{Scaling factor to increase sampling of cells. Cell counts in
\code{samples} are scaled up by being multiplied by this number. Only used if
\code{object} is a single cell count matrix.}

\item{method}{Either "dirichlet" or "unif" to specify whether cells are
sampled based on the Dirichlet distribution with K = number of cells in
each subclass, or sampled uniformly. When cells are oversampled uniformly,
in the limit the summed gene expression tends to the arithmetic mean of the
subclass x sample frequency. Dirichlet sampling provides proper randomness
with sampling.}

\item{alpha}{Shape parameter for Dirichlet sampling.}
}
\value{
An integer count matrix with genes in rows and cell subclasses in
columns. This can be used as \code{test} with the \code{\link[=deconvolute]{deconvolute()}} function.
}
\description{
Simulates pseudo-bulk RNA-Seq dataset using two modes. The first mode uses a
'cellMarkers' class object and a matrix of counts for the numbers of cells of
each cell subclass. This method converts the log2 gene means back for
each cell subclass back to count scale and then calculates pseudo-bulk count
values based on the cell amounts specified in \code{samples}. In the 2nd mode, a
single-cell RNA-Seq dataset is required, such as a matrix used as input to
\code{\link[=cellMarkers]{cellMarkers()}}. Cells from the relevant subclass are sampled from the
single-cell matrix in the appropriate amounts based on \code{samples}, except that
sampling is scaled up by the factor \code{times}.
}
\details{
The first method can give perfect deconvolution if the following settings are
used with \code{\link[=deconvolute]{deconvolute()}}: \code{count_space = TRUE}, \code{convert_bulk = FALSE},
\code{use_filter = FALSE} and \code{comp_amount = 1}.
}
\seealso{
\code{\link[=generate_samples]{generate_samples()}} \code{\link[=deconvolute]{deconvolute()}} \code{\link[=add_noise]{add_noise()}}
}
