% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/datsim.R
\name{datsim}
\alias{datsim}
\title{Simulate Data for a Single Response Style}
\usage{
datsim(nr.indv = 100, m = 5, scales = 1:7, err.coeff = 0.1,
  resp.style = c(-Inf, 1/7, 2/7, 3/7, 4/7, 5/7, 6/7, Inf), true.mu = NULL,
  a = 0, b = 1, plot.graph = FALSE, use.copula = FALSE,
  reverse.thresh = 1, ...)
}
\arguments{
\item{nr.indv}{Integer giving the number of individuals required in the sample.}

\item{m}{The number of items.}

\item{scales}{The rating scale used for all items.}

\item{err.coeff}{The standard error used in simulating the truncated normal distribution.}

\item{resp.style}{A set of cut points across the interval [0, 1] defining the response style
transformation.}

\item{true.mu}{Optional vector of length \code{m} giving the true preferences for the items.}

\item{a}{Lower boundary of the truncation interval for the simulated true preferences.}

\item{b}{Upper boundary for the truncation interval for the simulated true preferences.}

\item{plot.graph}{Logical indicating whether to visualize the response style in a plot.}

\item{use.copula}{Logical indicating whether to simulate dependent items using a copula.}

\item{reverse.thresh}{A proportion giving the proportion of item preferences which should be
reversed to induce a negative association.}

\item{\dots}{Additional arguments passed to \code{\link{plot}}.}
}
\description{
Simulate data containing a single repsponse style.
}
\author{
Pieter C. Schoonees
}
\references{
Schoonees, P.C., Velden, M. van de & Groenen, P.J.F. (2013).
Constrained Dual Scaling for Detecting Response Styles in Categorical Data.
(EI report series EI 2013-10). Rotterdam: Econometric Institute.
}
\keyword{multivariate}

