% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowsColumns.R
\name{moveValuesToRows}
\alias{moveValuesToRows}
\title{Move values from columns to rows (wrapper for \code{tidyr::gather}, or anti-pivot).}
\usage{
moveValuesToRows(data, nameForNewKeyColumn, nameForNewValueColumn,
  columnsToTakeFrom, allowNAKeys = FALSE, na.rm = FALSE, convert = FALSE,
  factor_key = FALSE)
}
\arguments{
\item{data}{data.frame to work with.}

\item{nameForNewKeyColumn}{character name of column to write new keys in.}

\item{nameForNewValueColumn}{character name of column to write new values in.}

\item{columnsToTakeFrom}{character array names of columns to take values from.}

\item{allowNAKeys}{logical if FALSE throw if there are NAs in the key columns.}

\item{na.rm}{passed to \code{tidyr::gather}}

\item{convert}{passed to \code{tidyr::gather}}

\item{factor_key}{passed to \code{tidyr::gather}}
}
\value{
new data.frame with values moved to rows.
}
\description{
For a tutorial please try \code{vignette('RowsAndColumns', package='cdata')}.
}
\examples{

d <- data.frame(AUC= 0.6, R2= 0.2)
moveValuesToRows(d,
                 nameForNewKeyColumn= 'meas',
                 nameForNewValueColumn= 'val',
                 columnsToTakeFrom= c('AUC', 'R2'))

}
\seealso{
\code{\link{moveValuesToColumns}}
}
