% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ccdr_options.R
\name{ccdr_options}
\alias{ccdr_options}
\alias{set_ccdr_option}
\alias{has_ccdr_options}
\alias{has_ccdr_option}
\title{ccdr Options}
\usage{
set_ccdr_option(...)

has_ccdr_options()

has_ccdr_option(option)
}
\arguments{
\item{...}{a named listing of options to set}

\item{option}{a specific option to query, e.g. \code{display_api_key}}
}
\value{
\itemize{
\item \code{set_ccdr_option()} does not have a return value but has the side effect
of setting options used by other functions.
\item \code{has_ccdr_option()} returns a Boolean.
\item \code{has_ccdr_options()} returns a Boolean.
}
}
\description{
ccdr stores options as a named list in R's global options, i.e.
\code{getOption('ccdr')}. It currently stores two such options, one for CCTE
credentialing and one to supress private API information in the URLs printed
to the screen when web queries are placed. For both of those, see
\code{\link[=register_ccte]{register_ccte()}}.
}
\examples{
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set ccdr options
set_ccdr_option('display_api_key' = FALSE)
\dontshow{\}) # examplesIf}
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Check if there are options registered to 'ccdr'
has_ccdr_options()
\dontshow{\}) # examplesIf}
\dontshow{if (has_ccte_key() & is.na(ccte_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Check if a specific option is registered for 'ccdr'
has_ccdr_option('display_api_key')
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=register_ccte]{register_ccte()}}
}
