% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/np_boot_ccc_by_time.R
\name{np_boot_ccc_by_time}
\alias{np_boot_ccc_by_time}
\title{Non-parametric cluster bootstrap to make inference on the concordance correlation coefficient by time variable}
\usage{
np_boot_ccc_by_time(
  dataset,
  ry,
  rind,
  rmet,
  rtime,
  covar = NULL,
  int = FALSE,
  cl = 0.95,
  control.lme = list(),
  nboot = 500,
  future_seed = 123
)
}
\arguments{
\item{dataset}{an object of class \code{data.frame}}

\item{ry}{Character string. Name of the outcome in the data set.}

\item{rind}{Character string. Name of the subject variable in the data set.}

\item{rmet}{Character string. Name of the method variable in the data set.}

\item{rtime}{Character string. Name of the time variable in the data set.}

\item{covar}{Character vector. Name of covariates to include in the linear mixed model as fixed effects.}

\item{int}{Binary indicating if the subject-method interaction has to be included in the model when analyzing the non-longitudinal setting (defaults to FALSE).}

\item{cl}{Confidence level.}

\item{control.lme}{A list of control values for the estimation algorithm used in \code{lme} function. For further details see \code{lme} help.}

\item{nboot}{Number of bootstrap resamples.}

\item{future_seed}{Logical/Integer. The seed to be used for parallellization. Further details in \code{furrr_options}.}
}
\value{
Vector of CCC bootstrap estimates.
}
\description{
Non-parametric cluster bootstrap to make inference on the concordance correlation coefficient by time variable
}
\keyword{internal}
