% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/scalar_wts.R
\name{scalar_wts}
\alias{scalar_wts}
\title{This function calculates scalar weights for use in other models}
\usage{
scalar_wts(treat,
           treat_formula,
           numerator_formula,
           data,
           treat_mod,
           link_function,
           ...)
}
\arguments{
\item{treat}{is the name of the treatment variable contained in
\code{data}.}

\item{treat_formula}{an object of class "formula" (or one that can be
coerced to that class) that regresses \code{treat} on a linear combination
of \code{X}: a symbolic description of the model to be fitted.}

\item{numerator_formula}{an object of class "formula" (or one that can be
coerced to that class) that regresses \code{treat} on a linear combination
of \code{X}: a symbolic description of the model to be fitted.  i.e.
\code{treat ~ 1}.}

\item{data}{is a dataframe containing \code{treat}, and
\code{X}.}

\item{treat_mod}{a description of the error distribution to be used in the
model for treatment. Options include: \code{"Normal"} for normal model,
\code{"LogNormal"} for lognormal model, \code{"Poisson"} for Poisson model,
\code{"NegBinom"} for negative binomial model, \code{"Gamma"} for gamma
model.}

\item{link_function}{is either "log", "inverse", or "identity" for the
"Gamma" \code{treat_mod}.}

\item{...}{additional arguments to be passed to the treatment regression fitting function.}
}
\value{
\code{scalar_wts}  returns an object of class "causaldrf_wts",
a list that contains the following components:

\item{param}{summary of estimated weights.}
\item{t_mod}{the result of the treatment model fit.}
\item{num_mod}{the result of the numerator model fit.}
\item{weights}{estimated weights for each unit.}
\item{call}{the matched call.}
}
\description{
This function calculates the scalar weights
}
\examples{
## Example from Schafer (2015).

example_data <- sim_data

scalar_wts_list <- scalar_wts(treat = T,
                     treat_formula = T ~ B.1 + B.2 + B.3 + B.4 + B.5 + B.6 + B.7 + B.8,
                     numerator_formula = T ~ 1,
                     data = example_data,
                     treat_mod = "Normal")

sample_index <- sample(1:1000, 100)

plot(example_data$T[sample_index],
     scalar_wts_list$weights[sample_index],
     xlab = "T",
     ylab = "weights",
     main = "scalar_wts")


rm(example_data, scalar_wts_list, sample_index)
}
\references{
Schafer, J.L., Galagate, D.L. (2015).  Causal inference with a
continuous treatment and outcome: alternative estimators for parametric
dose-response models. \emph{Manuscript in preparation}.
}
\seealso{
\code{\link{iptw_est}}, \code{\link{ismw_est}},
 \code{\link{reg_est}}, \code{\link{aipwee_est}}, \code{\link{wtrg_est}},
  etc. for other estimates.

\code{\link{t_mod}}, \code{\link{overlap_fun}} to prepare the \code{data}
for use in the different estimates.
}

