% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_to_py.R
\name{sinkhorn}
\alias{sinkhorn}
\title{Sinkhorn Loss}
\usage{
sinkhorn(
  x,
  y,
  a,
  b,
  power = 2,
  blur = 0.05,
  reach = NULL,
  diameter = NULL,
  scaling = 0.5,
  truncate = 5,
  metric = "Lp",
  cluster_scale = NULL,
  debias = TRUE,
  verbose = FALSE,
  backend = "auto",
  ...
)
}
\arguments{
\item{x}{covariates for the first set of samples. Should be of class matrix.}

\item{y}{covariates for the second set of samples. Should be of class matrix.}

\item{a}{The empirical measure of the first set of samples.}

\item{b}{The empirical measure of the second set of samples.}

\item{power}{power of the optimal transport distance.}

\item{blur}{The finest level of detail that should be handled by the loss function to prevent overfitting on the samples/ locations.}

\item{reach}{specifies the typical scale associated to the constraint strength}

\item{diameter}{A rough indication of the maximum distance between points, which is used to tune the espilon-scaling descent and provide a default heuristic for clustering multiscale schemes. If None, a conservative estimate will be computed on-the-fly.}

\item{scaling}{specifies the ratio between successive values of sigma in the epsilon-scaling descent. This parameter allows you to specify the trade-off between speed (scaling < .4) and accuracy (scaling > .9).}

\item{truncate}{If backend is "multiscale", specifies the effective support of a Gaussian/Laplacian kernel as a multiple of its standard deviation}

\item{metric}{Set the metric. One of "Lp","sdLp", or "mahalanobis".}

\item{cluster_scale}{If backend is "multiscale", specifies the coarse scale at which cluster centroids will be computed. If NULL, a conservative estimate will be computed from diameter and the ambient space's dimension, making sure that memory overflows won't take place.}

\item{debias}{specifies if we should compute the unbiased Sinkhorn divergence instead of the classic, entropy-regularized "SoftAssign" loss.}

\item{verbose}{if backend is "multiscale", specifies whether information on the clustering and epsilon-scaling descent should be displayed in the standard output.}

\item{backend}{one of "auto", "tensorized", "online", or "multiscale"}

\item{...}{not currently used. Used to absorb extra arguments passed
by other functions without throwing an error.}
}
\value{
a list with slots "loss", "f", "g". "loss" is the Sinkhorn distance,
"f" is the potential corresponding to data \code{x}, and "g" is the potential
corresponding to data \code{y}.
}
\description{
This function serves as an R wrapper to the Python function SamplesLoss in the GeomLoss package \url{http://www.kernel-operations.io/geomloss/api/pytorch-api.html?highlight=samplesloss#geomloss.SamplesLoss}
}
\examples{
\dontrun{
# requires Python and GeomLoss package
x <- stats::rnorm(100, 100, 10)
a <- rep(1/100, 100)

y <- stats::rnorm(50, 50, 10)
b <- rep(1/50, 50)

sink <- sinkhorn(x = x, y = y, a = a, b = b, power = 2,
              metric = "Lp", debias = TRUE)

# sinkhorn distance, de-biased
print(sink$loss)

# potentials for first 5 obs in each group
print(sink$f[1:5])
print(sink$g[1:5])
}
}
