% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_sim_class.R
\name{LaLonde}
\alias{LaLonde}
\title{LaLonde data example}
\value{
An \link[R6:R6Class]{R6} object of class \link{DataSim}
}
\description{
LaLonde data example

LaLonde data example
}
\details{
Returns the LaLonde data as used by Dehjia and Wahba. Note the data
is fixed and \code{gen_data()} will just initialize the fixed data.
}
\examples{

## ------------------------------------------------
## Method `LaLonde$new`
## ------------------------------------------------

nsw <- LaLonde$new(design = "NSW")
nsw$gen_data()
nsw$get_n()

obs.study <-  LaLonde$new(design = "Full")
obs.study$gen_data()
obs.study$get_n()
}
\section{Super class}{
\code{\link[causalOT:DataSim]{causalOT::DataSim}} -> \code{LaLonde}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-gen_data}{\code{LaLonde$gen_data()}}
\item \href{#method-get_tau}{\code{LaLonde$get_tau()}}
\item \href{#method-gen_x}{\code{LaLonde$gen_x()}}
\item \href{#method-gen_y}{\code{LaLonde$gen_y()}}
\item \href{#method-gen_z}{\code{LaLonde$gen_z()}}
\item \href{#method-new}{\code{LaLonde$new()}}
\item \href{#method-get_design}{\code{LaLonde$get_design()}}
\item \href{#method-clone}{\code{LaLonde$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_n">}\href{../../causalOT/html/DataSim.html#method-get_n}{\code{causalOT::DataSim$get_n()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_p">}\href{../../causalOT/html/DataSim.html#method-get_p}{\code{causalOT::DataSim$get_p()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_x">}\href{../../causalOT/html/DataSim.html#method-get_x}{\code{causalOT::DataSim$get_x()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_x0">}\href{../../causalOT/html/DataSim.html#method-get_x0}{\code{causalOT::DataSim$get_x0()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_x1">}\href{../../causalOT/html/DataSim.html#method-get_x1}{\code{causalOT::DataSim$get_x1()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_y">}\href{../../causalOT/html/DataSim.html#method-get_y}{\code{causalOT::DataSim$get_y()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="get_z">}\href{../../causalOT/html/DataSim.html#method-get_z}{\code{causalOT::DataSim$get_z()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="opt_weight">}\href{../../causalOT/html/DataSim.html#method-opt_weight}{\code{causalOT::DataSim$opt_weight()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="causalOT" data-topic="DataSim" data-id="opt_weight_dist">}\href{../../causalOT/html/DataSim.html#method-opt_weight_dist}{\code{causalOT::DataSim$opt_weight_dist()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gen_data"></a>}}
\if{latex}{\out{\hypertarget{method-gen_data}{}}}
\subsection{Method \code{gen_data()}}{
Sets up the data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$gen_data()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_tau"></a>}}
\if{latex}{\out{\hypertarget{method-get_tau}{}}}
\subsection{Method \code{get_tau()}}{
Returns the experimental treatment effect, $1794
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$get_tau()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gen_x"></a>}}
\if{latex}{\out{\hypertarget{method-gen_x}{}}}
\subsection{Method \code{gen_x()}}{
Sets up the covariate data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$gen_x()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gen_y"></a>}}
\if{latex}{\out{\hypertarget{method-gen_y}{}}}
\subsection{Method \code{gen_y()}}{
Sets up the outcome data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$gen_y()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gen_z"></a>}}
\if{latex}{\out{\hypertarget{method-gen_z}{}}}
\subsection{Method \code{gen_z()}}{
Sets up the treatment indicator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$gen_z()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initializes the LaLonde object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$new(n = NULL, p = NULL, param = list(), design = "NSW", ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Not used.
Maintained for symmetry with other
DataSim objects.}

\item{\code{p}}{Not used.
Maintained for symmetry with other
DataSim objects.}

\item{\code{param}}{Not used.
Maintained for symmetry with other
DataSim objects.}

\item{\code{design}}{One of "NSW" or "Full".
"NSW" uses the original experimental data
from the job training program while option "Full"
uses the treated individuals from
LaLonde's study and compares them to
individuals from the
Current Population Survey as controls.}

\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{nsw <- LaLonde$new(design = "NSW")
nsw$gen_data()
nsw$get_n()

obs.study <-  LaLonde$new(design = "Full")
obs.study$gen_data()
obs.study$get_n()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_design"></a>}}
\if{latex}{\out{\hypertarget{method-get_design}{}}}
\subsection{Method \code{get_design()}}{
Returns the chosen design parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$get_design()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LaLonde$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
