% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cauphylm.R
\name{compute_vcov}
\alias{compute_vcov}
\title{Compute Approximated Variance Covariance Matrix}
\usage{
compute_vcov(obj)
}
\arguments{
\item{obj}{a fitted object, either with \code{\link{fitCauchy}} or \code{\link{cauphylm}}.}
}
\value{
The same object, with added vcov entry.
}
\description{
Find the approximated variance covariance matrix of the parameters.
}
\details{
This function computes the numerical Hessian of the likelihood at the optimal value
using function \code{\link[pracma]{hessian}}, and then uses its inverse 
to approximate the variance covariance matrix.
It can be used to compute confidence intervals with functions \code{\link{confint.cauphylm}}
or \code{\link{confint.cauphyfit}}.

\code{\link{confint.cauphylm}} and \code{\link{confint.cauphyfit}}
internally call \code{compute_vcov}, but do not save the result.
This function can be used to save the vcov matrix.
}
\examples{
# Simulate tree and data
set.seed(1289)
phy <- ape::rphylo(20, 0.1, 0)
dat <- rTraitCauchy(n = 1, phy = phy, model = "cauchy",
                    parameters = list(root.value = 10, disp = 0.1))
# Fit the data, without computing the Hessian at the estimated parameters.
fit <- fitCauchy(phy, dat, model = "cauchy", method = "reml", hessian = FALSE)
# Precompute the vcov matrix
fit <- compute_vcov(fit)
# Approximate confidence intervals
confint(fit)

}
\seealso{
\code{\link{fitCauchy}}, \code{\link{cauphylm}}, 
\code{\link{confint.cauphylm}}, \code{\link{confint.cauphyfit}},
\code{\link{vcov.cauphylm}}, \code{\link{vcov.cauphyfit}}
}
