% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-handlers.R
\name{user_exit}
\alias{user_exit}
\alias{exit_with}
\title{Force an exit}
\usage{
user_exit(expr = NULL)

exit_with(expr, as_fn = FALSE)
}
\arguments{
\item{expr}{An optional expression which if specified, will be evaluated after \code{user_exit} exits the evaluation.}

\item{as_fn}{A logical; if \code{TRUE}, catchr will try to convert \code{expr} into a function via \code{\link[rlang:as_function]{rlang::as_function()}} which will be applied to the condition. It will fall back to normal behavior if this coercion raises an error.}
}
\description{
These functions force a catchr plan to immediately exit the evaluation of an expression (and the rest of the plan), similar to how \code{\link[=catchr-DSL]{exit}} works. But unlike \code{exit} and most catchr functions or special reserved terms, these functions are meant to be used in the user-defined functions of a plan.

\code{user_exit()} forces the code to exit, and after exiting, evaluate whatever expression was supplied. This function should be used \emph{within} a custom function, i.e., \code{function(x) {user_exit(print("DONE!"))}}.

\code{exit_with()} can be used at the "top" level of a plan, since it returns a \emph{function} that calls \code{user_exit()}. Thus \code{exit_with(print("DONE!"))} is equivalent to the example above. Additionally, if \code{as_fn} is set to \code{TRUE}, it will attempt to coerce \code{expr} into a function via \code{rlang}'s \code{\link[rlang:as_function]{rlang::as_function()}}. If \code{expr} can be converted, \code{exit_with()} will return a function that takes in a condition, modifies it via \code{expr}, and then supplies this to \code{user_exit}.  E.g., \code{exit_with(~.$message)} is equivalent to \code{function(cond) {user_exit(cond$message)}}
}
\examples{
yay <- catch_expr({warning("oops"); "done!"},
                  warning = exit_with("YAY"))

# This won't work, since `user_exit("YAY")` doesn't evaluate to a function/string
\dontrun{
yay <- catch_expr({warning("oops"); "done!"},
                  warning = user_exit("YAY"))
}

check <- function(cond) {
  if (inherits(cond, "simpleWarning"))
    user_exit(rlang::warn(paste0("Check it: ", cond$message)))
  else
    invokeRestart(first_muffle_restart(cond))
  NULL
}

result <- catch_expr(
  { rlang::warn("This will be muffled")
    warning("This won't be muffled") },
  warning = check)
# Notice that `result` takes whatever the last (invisibly)
#   returned value is. Here, that's the message from the warning
result

# If you don't want to accidentally assign what is returned by `user_exit`,
#   either add `NULL` to the end of the expresion:
result2 <- catch_expr(
  { rlang::warn("This will be muffled")
    warning("This won't be muffled")},
  warning = function(x) { user_exit({ warning("This won't be assigned"); NULL})})
result2

# Or you can just do the assignment _within_ the expression being evaluated:
result3 <- NULL
catch_expr({result3 <- {
    rlang::warn("This will be muffled")
    warning("This won't be muffled")}},
  warning = check)
result3
}
\seealso{
the \link{exit} special term, which essentially becomes \code{exit_with(NULL)}; \code{\link[=user_display]{user_display()}} and \code{\link[=display_with]{display_with()}} for parallel functions for the \link{display} special term, and \code{\link[=beep_with]{beep_with()}} for a parallel function for the \link{beep} special term..
}
