% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{refresh}
\alias{refresh}
\alias{recover_partitions}
\alias{refresh_by_path}
\alias{refresh_table}
\title{Refreshing Data}
\usage{
recover_partitions(sc, table)

refresh_by_path(sc, path)

refresh_table(sc, table)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{table}{\code{character(1)}. The name of the table.}

\item{path}{\code{character(1)}. The path to refresh.}
}
\value{
\code{NULL}, invisibly. These functions are mostly called for their side effects.
}
\description{
\itemize{
\item \code{recover_partitions()}: Recovers all the partitions in the directory of a
table and update the catalog. This only works for partitioned tables and not
un-partitioned tables or views.
\item \code{refresh_by_path()}: Invalidates and refreshes all the cached data (and the
associated metadata) for any Dataset that contains the given data source
path. Path matching is by prefix, i.e. "/" would invalidate everything that
is cached.
\item \code{refresh_table()}: Invalidates and refreshes all the cached data and
metadata of the given table. For performance reasons, Spark SQL or the
external data source library it uses might cache certain metadata about a
table, such as the location of blocks. When those change outside of Spark
SQL, users should call this function to invalidate the cache. If this table
is cached as an \code{InMemoryRelation}, drop the original cached version and make
the new version cached lazily.
}
}
\seealso{
\code{\link[=cache_table]{cache_table()}}, \code{\link[=create_table]{create_table()}}, \code{\link[=get_table]{get_table()}}, \code{\link[=list_tables]{list_tables()}},
\code{\link[=table_exists]{table_exists()}}, \code{\link[=uncache_table]{uncache_table()}}
}
