% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{list_tables}
\alias{list_tables}
\title{List Tables In A Spark Connection}
\usage{
list_tables(sc, database = NULL)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{database}{\code{character(1)}. The name of the database for which the
functions should be listed (default: \code{NULL}).}
}
\value{
A \code{tibble} containing 5 columns:
\itemize{
\item \code{name} - The name of the table.
\item \code{database} - Name of the database the table belongs to.
\item \code{description} - Description of the table.
\item \code{tableType} - The type of table (e.g. view/table)
\item \code{isTemporary} - Whether the table is temporary or not.
}
}
\description{
Returns a list of tables/views in the current database. The result includes
the name, database, description, table type and whether the table is
temporary or not.
}
\examples{
\dontrun{
sc <- sparklyr::spark_connect(master = "local")
mtcars_spakr <- sparklyr::copy_to(dest = sc, df = mtcars)
list_tables(sc = sc)
}

}
\seealso{
\code{\link[=cache_table]{cache_table()}}, \code{\link[=create_table]{create_table()}}, \code{\link[=get_table]{get_table()}}, \code{\link[=refresh_table]{refresh_table()}},
\code{\link[=table_exists]{table_exists()}}, \code{\link[=uncache_table]{uncache_table()}}
}
