% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalClusterQuality.R
\encoding{UTF-8}
\name{evaluateClusterQuality}
\alias{evaluateClusterQuality}
\title{Evaluate Quality of Cluster Analysis Solution}
\usage{
evaluateClusterQuality(X, M, alpha = .05, M.order = NULL, 
quiet = FALSE, digits = getOption("digits"), ...)
}
\arguments{
\item{X}{three-way array; the \code{I, J, M} array has \code{I}
assessors, \code{J} products, code{M} attributes where CATA data have values 
\code{0} (not checked) and \code{1} (checked)}

\item{M}{cluster memberships}

\item{alpha}{significance level to be used for two-tailed tests}

\item{M.order}{can be used to change the cluster numbers (e.g. to label 
cluster 1 as cluster 2 and vice versa); defaults to \code{NULL}}

\item{quiet}{if \code{FALSE} (default) then it prints information quality
measures; if \code{TRUE} then returns results without printing}

\item{digits}{significant digits (to display)}

\item{...}{other parameters for \code{\link[base]{print.default}} (if 
\code{quiet = TRUE}).}
}
\value{
A list containing cluster analysis quality measures: 
\itemize{
 \item{\code{$solution} : 
   \itemize{
   \item{\code{Pct.b} = percentage of the total sensory differentiation 
   retained in the solution}
   \item{\code{min(NR)} = smallest observed between-cluster non-redundancy}
   \item{\code{Div_G} = overall diversity (coverage)}
   \item{\code{H_G} = overall homogeneity (weighted average of within-cluster
   homogeneity indices)}
   \item{\code{avRV} = average RV coefficient for all between-cluster 
   comparisons}}}
 \item{\code{$clusters} : 
   \itemize{
   \item{\code{ng} = number of cluster members}
   \item{\code{bg} = sensory differentiation retained in cluster}
   \item{\code{xbarg} = average citation rate in cluster}
   \item{\code{Hg} = homogeneity index within cluster (see 
   \code{\link[cata]{homogeneity}})}
   \item{\code{Dg} = within-cluster product discrimination}}}
 \item{\code{$nonredundancy.clusterpairs} : 
   \itemize{
   \item{square data frame showing non-redundancy for each pair of clusters
   (low values indicate high redundancy)}}}
 \item{\code{$rv.clusterpairs} : 
   \itemize{
   \item{square data frame with RV coefficient for each pair of clusters
   (high values indicate higher similarity in product configurations)}}}}
}
\description{
Evaluate the quality of cluster analysis solutions using measures related to
within-cluster product discrimination, between-cluster non-redundancy,
overall diversity (coverage), average RV, sensory differentiation retained,
and within-cluster homogeneity.
}
\examples{
data(bread)
evaluateClusterQuality(bread$cata[1:14,,1:6], M = rep(1:2, each = 7))
}
\references{
Castura, J.C., Meyners, M., Varela, P., & Næs, T. (2022). 
Clustering consumers based on product discrimination in check-all-that-apply 
(CATA) data. \emph{Food Quality and Preference}, 104564. 
\doi{10.1016/j.foodqual.2022.104564}.
}
\seealso{
\code{\link[cata]{homogeneity}}
}
