% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{prior}
\alias{prior}
\title{Evaluate the Prior Density Distribution at Position \code{x}}
\usage{
prior(x, dist, params)
}
\arguments{
\item{x}{A numeric value at which to evaluate the prior}

\item{dist}{A string indicating the distribution (slot \code{priorName} of \code{Cat} object)}

\item{params}{A length two numeric vector indicating the parameters of the distribution (slot \code{priorParams} of \code{Cat} object)}
}
\value{
The function \code{prior} returns a numeric consisting of prior value, \eqn{\pi(x)}, given the value \code{x}.
}
\description{
Calculates the density at \code{x} of either the normal, Student's t, or uniform distribution.
}
\details{
The \code{dist} argument needs to be either \code{"UNIFORM"}, \code{"NORMAL"}, or \code{"STUDENT_T"}.

When \code{dist} is \code{"NORMAL"}, the first element of \code{params} is the mean, 
the second element is the standard deviation.

When \code{dist} is \code{"STUDENT_T"}, the first 
element of \code{params} is the non-centrality parameters and the second is degrees of freedom.  

When \code{dist} is \code{"UNIFORM"}, the elements of \code{params} are the lower and upper bounds,
of the interval, respectively.  Note that the \code{"UNIFORM"} is only applicable for the expected a posteriori (EAP) estimation method.
}
\note{
This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.

This function uses Boost \code{C++} source libraries for the uniform and Student's t
distributions and calls \code{dnorm4} written in \code{C} which is identical to that 
of \code{dnorm} in \code{R}.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Prior calculation for different distributions
ltm_cat@priorName <- "NORMAL"
ltm_cat@priorParams <- c(0, 1) ## Parameters are mean and standard deviation
prior(x = 1, ltm_cat@priorName, ltm_cat@priorParams)

ltm_cat@priorName <- "STUDENT_T"
ltm_cat@priorParams <- c(1, 3) ## Parameters are non-centrality param and degrees of freedom
prior(x = 1, ltm_cat@priorName, ltm_cat@priorParams)

ltm_cat@priorName <- "UNIFORM"
ltm_cat@priorParams <- c(-1, 1) ## Parameters are lower bound and upper bound of interval
prior(x = 1, ltm_cat@priorName, ltm_cat@priorParams)


}
\seealso{
\code{\link{Cat-class}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery,
 Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
