% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{sc_stringy}
\alias{sc_stringy}
\alias{sc_stringy.default}
\alias{sc_stringy.scree}
\alias{sc_stringy.igraph}
\title{Compute stringy scagnostic measure using MST}
\usage{
sc_stringy(x, y)

\method{sc_stringy}{default}(x, y)

\method{sc_stringy}{scree}(x, y = NULL)

\method{sc_stringy}{igraph}(x, y = NULL)
}
\arguments{
\item{x}{numeric vector of x values}

\item{y}{numeric vector of y values}
}
\value{
A "numeric" object that gives the plot's stringy score.
}
\description{
Compute stringy scagnostic measure using MST
}
\examples{
  require(ggplot2)
  require(tidyr)
  require(dplyr)
  data(anscombe_tidy)
  ggplot(anscombe_tidy, aes(x=x, y=y)) +
    geom_point() +
    facet_wrap(~set, ncol=2, scales = "free")
  sc_stringy(anscombe$x1, anscombe$y1)
  sc_stringy(anscombe$x2, anscombe$y2)
  sc_stringy(anscombe$x3, anscombe$y3)
  sc_stringy(anscombe$x4, anscombe$y4)

}
