% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{sc_clumpy}
\alias{sc_clumpy}
\alias{sc_clumpy.default}
\alias{sc_clumpy.scree}
\alias{sc_clumpy.igraph}
\title{Compute clumpy scagnostic measure using MST}
\usage{
sc_clumpy(x, y)

\method{sc_clumpy}{default}(x, y)

\method{sc_clumpy}{scree}(x, y = NULL)

\method{sc_clumpy}{igraph}(x, y)
}
\arguments{
\item{x}{numeric vector of x values}

\item{y}{numeric vector of y values}
}
\value{
A "numeric" object that gives the plot's clumpy score.
}
\description{
Compute clumpy scagnostic measure using MST
}
\examples{
  require(ggplot2)
  require(dplyr)
  ggplot(features, aes(x=x, y=y)) +
     geom_point() +
     facet_wrap(~feature, ncol = 5, scales = "free")
  features \%>\% group_by(feature) \%>\% summarise(clumpy = sc_clumpy(x,y))
  sc_clumpy(datasaurus_dozen_wide$away_x, datasaurus_dozen_wide$away_y)

}
