% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gap.R
\name{gap}
\alias{gap}
\title{Grid element spacing}
\usage{
gap(x, size)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{size}{A \link{responsive} argument.

One of \code{0}, \code{1}, \code{2}, \code{3}, \code{4}, or \code{5} specifying the amount of gap space.}
}
\description{
The \code{gap()} function is used to space child elements of a parent tag element
with \code{display("grid")}. Instead of specifying a margin for each child element
a gap may be specified for the parent element. This function will have no
effect on element's without display set to \code{"grid"}.
}
\details{
Internet Explorer does not support the grid display layout.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    display("grid") \%>\%
    gap(2),
  div("Child 1"),
  div("Child 2"),
  div("Child 3")
)

}
