% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legends.R
\name{legendTypo}
\alias{legendTypo}
\title{Legend for Typology Maps}
\usage{
legendTypo(pos = "topleft", title.txt = "Title of the legend",
  title.cex = 0.8, values.cex = 0.6, col, categ, cex = 1, nodata = TRUE,
  nodata.txt = "No data", nodata.col = "white", frame = FALSE,
  symbol = "box")
}
\arguments{
\item{pos}{position of the legend, one of "topleft", "top", 
"topright", "right", "bottomright", "bottom", "bottomleft", "left" or a 
vector of two coordinates in map units (c(x, y)).}

\item{title.txt}{title of the legend.}

\item{title.cex}{size of the legend title.}

\item{values.cex}{size of the values in the legend.}

\item{col}{a vector of colors.}

\item{categ}{vector of categories.}

\item{cex}{size of the legend. 2 means two times bigger.}

\item{nodata}{if TRUE a "no data" box or line is plotted.}

\item{nodata.txt}{label for "no data" values.}

\item{nodata.col}{color of "no data" values.}

\item{frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{symbol}{character; 'line' or 'box'}
}
\description{
Plot legend for typology maps.
}
\examples{
library(sp)
data("nuts2006")
plot(nuts0.spdf, col = "grey")
box()

# Define labels and colors
someLabels <- c("red color", "yellow color", "green color", "black color")
someColors <- c("red", "yellow", "green", "black")

# plot legend
legendTypo(pos = "bottomleft", title.txt = "Title of the legend", title.cex = 0.8,
           values.cex = 0.6, col = someColors, categ = someLabels, 
           cex = 0.75,
           nodata = TRUE, nodata.txt = "no data", frame = TRUE, symbol="box")
legendTypo(pos = "topright", title.txt = "", 
           title.cex = 1.5, cex = 1.25,
           values.cex = 1, col = someColors, categ = someLabels, 
           nodata = FALSE, frame = FALSE, symbol="line")
}
