% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBIF_data.R
\name{GBIF_data}
\alias{GBIF_data}
\title{Retrieve Species data from GBIF}
\usage{
GBIF_data(s, file = NULL, as_df = FALSE, ...)
}
\arguments{
\item{s}{\code{character} vector of species names.}

\item{file}{\code{character} with file to save the output. If not informed, data will not be
saved on folder.}

\item{as_df}{Should the output be a \code{dataframe}? Default is \code{FALSE}, returning a
\code{occurrences} object.}

\item{...}{Arguments to pass on \code{rgbif::occ_data()}.}
}
\value{
A \code{data.frame} with species occurrences data, or an \code{occurrences} object if
\code{as_df = FALSE}.
}
\description{
This function is a wrapper to get records from GBIF using \code{rgbif} and return a
\code{data.frame} ready to be used in caretSDM.
}
\examples{
\donttest{
# Select species names:
s <- c("Araucaria angustifolia", "Salminus brasiliensis")

# Run function:
oc <- GBIF_data(s)
}

}
\references{
https://www.gbif.org
}
\author{
Luíz Fernando Esser (luizesser@gmail.com)
https://luizfesser.wordpress.com
}
