% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_conformal_reg.R
\name{conformalRegressorByHorizon}
\alias{conformalRegressorByHorizon}
\title{Fit a horizon-specific conformal regressor for time series forecasting.}
\usage{
conformalRegressorByHorizon(horizon_errors)
}
\arguments{
\item{horizon_errors}{A named list where each element contains sorted
absolute errors for that horizon. Names should be "h1", "h2", etc.
This is typically produced by \code{calibrate_horizon_scores()}.}
}
\value{
A conformalRegressorByHorizon object containing:
\item{alphas_by_horizon}{List of sorted nonconformity scores for each horizon}
\item{max_horizon}{Maximum calibrated horizon}
\item{n_samples}{Number of calibration samples per horizon}
}
\description{
This function creates a conformal regressor that accounts for increasing
uncertainty at longer forecast horizons. It uses separate nonconformity
score distributions for each horizon h=1,2,3,..., resulting in prediction
intervals that naturally widen as the forecast horizon increases
(trumpet-shaped intervals).
}
\references{
Boström, H., 2022. crepes: a Python Package for Generating Conformal
Regressors and Predictive Systems. In Conformal and Probabilistic Prediction
and Applications. PMLR, 179.

Stankeviciute, K., Alaa, A. M., & van der Schaar, M., 2021.
Conformal Time-series Forecasting. NeurIPS 2021.
}
\author{
Resul Akay
}
