\name{diff.resamples}
\alias{diff.resamples}
\alias{summary.diff.resamples}
\title{Inferential Assessments About Model Performance}
\description{Methods for making inferences about differences between models }
\usage{
\method{diff}{resamples}(x, models = x$models, metric = x$metrics, test = t.test, ...)
\method{summary}{diff.resamples}(object, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
  \item{x}{an object generated by \code{resamples}}
  \item{models}{a character string for which models to compare}
  \item{metric}{a character string for which metrics to compare}
  \item{test}{a function to compute differences. The output of this function should have scalar outputs called \code{estimate} and \code{p.value}}
  \item{object}{a object generated by \code{diff.resamples}}
  \item{digits}{the number of significant differences to display when printing}
  \item{\dots}{further arguments to pass to \code{test}}
}
\details{
For each metric, all pair-wise differences are computed and tested to assess if the difference is equal to zero.
}
\value{
An object of class \code{"diff.resamples"} with elements:
  \item{call }{the call}
  \item{difs }{a list for each metric being compared. Each list contains a matrix with differences in columns and resamples in rows }
  \item{statistics }{a list of results generated by \code{test}}
  \item{models}{a character string for which models were compared.}
  \item{metrics }{a character string of performance metrics that were used}

or...

An object of class \code{"summary.diff.resamples"} with elements:
  \item{call }{the call}
  \item{table }{a list of tables that show the differences and p-values }
}

\author{Max Kuhn}

\seealso{\code{\link{resamples}}}

\examples{
\dontrun{
#load(url("http://caret.r-forge.r-project.org/Classification_and_Regression_Training_files/exampleModels.RData"))

resamps <- resamples(list(CART = rpartFit,
                          CondInfTree = ctreeFit,
                          MARS = earthFit))

difs <- diff(resamps)

difs

summary(difs)
}
}

\keyword{ models }

