% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahad.R
\name{mahad}
\alias{mahad}
\title{Find and graph Mahalanobis Distance (D) and flag potential outliers.}
\usage{
mahad(x, plot = TRUE, flag = FALSE, confidence = 0.99, na.rm = TRUE)
}
\arguments{
\item{x}{a matrix of data}

\item{plot}{Plot the resulting QQ graph}

\item{flag}{Flag potential outliers using the confidence level specified in parameter \code{confidence}}

\item{confidence}{The desired confidence level of the result}

\item{na.rm}{Should missing data be deleted}
}
\description{
Takes a matrix of item responses and computes Mahalanobis D. Can additionally return a
vector of binary outlier flags.
Mahalanobis distance is calculated using the function \code{psych::outlier} of the \pkg{psych}
package, an implementation which supports missing values.
}
\examples{
mahad_raw <- mahad(careless_dataset) #only the distances themselves
mahad_flags <- mahad(careless_dataset, flag = TRUE) #additionally flag outliers
mahad_flags <- mahad(careless_dataset, flag = TRUE, confidence = 0.999) #Apply a strict criterion
}
\references{
Meade, A. W., & Craig, S. B. (2012). Identifying careless responses in survey data.
\emph{Psychological Methods, 17(3)}, 437-455. \doi{10.1037/a0028085}
}
\seealso{
\code{psych::outlier} on which this function is based.
}
\author{
Richard Yentes \email{ryentes@gmail.com}, Francisco Wilhelm \email{franciscowilhelm@gmail.com}
}
