% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branching.R
\name{curvy_branch_clust_bkg}
\alias{curvy_branch_clust_bkg}
\title{Generate Curvy Branching Cluster Data with Background Noise}
\usage{
curvy_branch_clust_bkg(n, num_noise, min_n, max_n)
}
\arguments{
\item{n}{The total number of data points to be generated.}

\item{num_noise}{The number of additional noise dimensions to be generated.}

\item{min_n}{The minimum value for the noise added to the data points.}

\item{max_n}{The maximum value for the noise added to the data points.}
}
\value{
A matrix containing the generated data, with each row representing a data point.
}
\description{
This function generates data with four clusters, two of which follow a
curvilinear pattern and the other two are distributed randomly.
}
\examples{

# Generate curvy branching cluster data with background noise with custom parameters
set.seed(20240412)
data <- curvy_branch_clust_bkg(
  n = 400, num_noise = 2, min_n = -0.05,
  max_n = 0.05
)
}
