### R code from vignette source 'vignette.Rnw'

###################################################
### code chunk number 1: vignette.Rnw:133-137
###################################################
x <- c(0, 19, 38, 57, 76, 95, 114, 133, 152, 170, 190, 208, 227, 246, 265,
      284, 303, 322, 341, 360)
y <- c(0.9, 1, 1.2, 1, 2, 4, 7, 3, 4, 2, 1.1, 1, 1, 1, 0.9, 1.2, 1,
       0.8, 1.1, 1)


###################################################
### code chunk number 2: vignette.Rnw:142-143
###################################################
plot(x, y)


###################################################
### code chunk number 3: vignette.Rnw:156-158
###################################################
library("cardidates")
res <- fitweibull6(x, y)


###################################################
### code chunk number 4: vignette.Rnw:166-167
###################################################
summary(res)


###################################################
### code chunk number 5: vignette.Rnw:188-189
###################################################
plot(res)


###################################################
### code chunk number 6: vignette.Rnw:214-215
###################################################
data(carditest)


###################################################
### code chunk number 7: vignette.Rnw:227-228
###################################################
tt <- metaCDW(carditest, xstart = 55)


###################################################
### code chunk number 8: vignette.Rnw:233-234
###################################################
summary(tt)


###################################################
### code chunk number 9: vignette.Rnw:245-246
###################################################
plot(as.numeric(carditest$sample) * 365 + carditest$x, carditest$y, type = "b")


###################################################
### code chunk number 10: vignette.Rnw:265-266
###################################################
print(plot(tt, carditest, layout=c(1, 3)))


###################################################
### code chunk number 11: vignette.Rnw:365-368
###################################################
set.seed(537)
x <- seq(1, 360, length = 50)
y <- exp(cos(x/20)) + 0.3 + rnorm(x, sd = 0.3)


###################################################
### code chunk number 12: vignette.Rnw:376-377
###################################################
peaks <- peakwindow(x, y, xstart = 60)


###################################################
### code chunk number 13: vignette.Rnw:384-385
###################################################
plot(peaks)


###################################################
### code chunk number 14: vignette.Rnw:407-410
###################################################
smd   <- peaks$smd.indices
res <- fitweibull6(x[smd], y[smd])
summary(res)


###################################################
### code chunk number 15: vignette.Rnw:413-415
###################################################
plot(res, ylim = c(0, 4), xlim = c(0, 360))
points(x, y, pch = "+", type = "b")


###################################################
### code chunk number 16: vignette.Rnw:438-439
###################################################
CDW(res, symmetric = FALSE)


###################################################
### code chunk number 17: vignette.Rnw:444-445
###################################################
CDW(res, quantile = 0.01, symmetric = FALSE)


