\name{HuHuCAR.sim}
\alias{HuHuCAR.sim}
\alias{HuHuCAR.sim.carandom}
\title{Hu and Hu's General Covariate-Adaptive Randomization with Covariate Data Generating Mechanism}
\description{
Allocates patients generated by simulating covariates-profile on assumption of independence between covariates and levels within each covariate, to one of two treatments using general covariate-adaptive randomization proposed by Hu Y, Hu F (2012) <Doi:10.1214/12-AOS983>. 
}
\usage{
\method{HuHuCAR.sim}{carandom}(n = 1000, cov_num = 2, level_num = c(2, 2), 
            pr = rep(0.5, 4), omega = NULL, p = 0.85)
}
\arguments{
  \item{n}{number of patients. Default is \code{1000}.}
  \item{cov_num}{number of covariates. Default is \code{2}.}
  \item{level_num}{vector of level numbers for each covariates. Hence the length of level_num should equal to number of covariates. Default is \code{level_num = c(2, 2)}.}
  \item{pr}{vector of probabilities. Under assumption of independence between covariates, \code{pr} is a vector containing probabilities for each levels of each covariates. The length of \code{pr} should correspond to number of all levels; and sum of \code{pr} should equal \code{cov_num}. If \code{pr = rep(0.5, 4)} (default), it means \code{cov_num = 2}, and \code{level_num = c(2, 2)}.}
  \item{omega}{vector of weights at the overall, within-stratum as well as maginal levels. It is required that at least one element is larger than 0. If \code{omega = NULL} (default), it weights the overall, within-stratum as well as marginal levels with porpotion \code{1/cov_num}.}
  \item{p}{probabilities of assigning one patient to treatment 1. p should be larger than \code{1/2} to obtain balance. The default is \code{0.85}.}
}
\details{
See \code{\link{HuHuCAR}}.
}
\value{
See \code{\link{HuHuCAR}}. 
}
\seealso{
  See \code{\link{HuHuCAR}} for allocating patients with complete covariate data; See \code{\link{HuHuCAR.ui}} for command-line user interface. 
}