\name{StrPBR.sim}
\alias{StrPBR.sim}
\alias{StrPBR.sim.carandom}
\title{
Stratified Permuted Block Randomization for Simulated Data
}
\description{
Allocates patients generated by simulating covariates-profile on assumption of independence between covariates and levels within each covariate, to one of two treatments using stratified randomization proposed by Zelen M (1974) <Doi: 10.1016/0021-9681(74)90015-0>.
}
\usage{
\method{StrPBR.sim}{carandom}(n = 1000, cov_num = 2, level_num = c(2, 2), 
           pr = rep(0.5, 4), bsize = 4)
}
\arguments{
  \item{n}{number of patients. Default is \code{1000}.}
  \item{cov_num}{number of covariates.Default is \code{2}.}
  \item{level_num}{vector of level numbers for each covariates. Hence the length of level_num should equal to number of covariates. Default is \code{level_num = c(2, 2)}. }
  \item{pr}{vector of probabilities. Under assumption of independence between covariates, \code{pr} is a vector containing probabilities for each levels of each covariates. The length of \code{pr} should correspond to number of all levels; and sum of \code{pr} should equal \code{cov_num}. If \code{pr = rep(0.5, 4)} (default), it means \code{cov_num = 2}, and \code{level_num = c(2, 2)}.}
  \item{bsize}{block size for stratified randomization. It is required to be multiple of 2. Default is \code{4}.}
}
\details{
See \code{\link{StrPBR}}.
}
\value{
See \code{\link{StrPBR}}.
}
\seealso{
  See \code{\link{StrPBR}} for allocating a given completely collected data; See \code{\link{StrPBR.ui}} for command-line user interface. 
}