% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal-zip.R
\name{normal_zip}
\alias{normal_zip}
\title{Normalize ZIP codes}
\usage{
normal_zip(zip, na = c("", "NA"), na_rep = FALSE)
}
\arguments{
\item{zip}{A vector of US ZIP codes.}

\item{na}{A vector of values to pass to \code{\link[=na_in]{na_in()}}.}

\item{na_rep}{logical; If \code{TRUE}, \code{\link[=na_rep]{na_rep()}} will be called. Please note that
22222, 44444, and 55555 valid ZIP codes that will not be removed.}
}
\value{
A \emph{character} vector of normalized 5-digit ZIP codes.
}
\description{
Return consistent version US ZIP codes using \verb{stringr::str_*()} functions.
Non-number characters are removed, strings are padded with zeroes on the left
(leading zeroes for New England ZIP codes are often removed by Microsoft
Excel and other programs), and ZIP+4 suffixes are removed. Invalid ZIP codes
from a vector can be removed as well as single (repeating) character strings.
}
\examples{
normal_zip(
  zip = c("05672-5563", "N/A", "05401", "5819", "00000"),
  na = c("", "NA"),
  na_rep = TRUE
)
}
\seealso{
Other geographic normalization functions: 
\code{\link{abbrev_full}()},
\code{\link{abbrev_state}()},
\code{\link{check_city}()},
\code{\link{expand_abbrev}()},
\code{\link{expand_state}()},
\code{\link{fetch_city}()},
\code{\link{normal_address}()},
\code{\link{normal_city}()},
\code{\link{normal_state}()},
\code{\link{str_normal}()}
}
\concept{geographic normalization functions}
