% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calpassapi.R
\name{calpass_get_token}
\alias{calpass_get_token}
\title{Obtain CalPASS API token}
\usage{
calpass_get_token(username = Sys.getenv("cp_api_uid"),
  password = Sys.getenv("cp_api_pwd"), client_id, scope,
  auth_endpoint = "https://oauth.calpassplus.org/connect/token",
  verbose = FALSE)
}
\arguments{
\item{username}{API username.  For security reasons, the user could specify \code{cp_api_uid} in the user's \code{.Renviron} file in the user's home directory (execute \code{Sys.getenv('HOME')} in R to check path to home directory).  That way, the user does not have to hard code the username in their R script.  The function uses for the username here by default.}

\item{password}{API password.  The user could specify \code{cp_api_pwd} as above.}

\item{client_id}{parameter needed in the http body in order to obtain a token (unique to \code{username})}

\item{scope}{parameter needed in the http body in order to obtain a token (unique to \code{username})}

\item{auth_endpoint}{Authentication endpoint/url, defaults to \code{'https://oauth.calpassplus.org/connect/token'}.}

\item{verbose}{If \code{TRUE}, then print http exchanges (to assist with debugging).  Defaults to \code{FALSE}.}
}
\value{
CalPASS token string
}
\description{
Obtain a token from CalPASS using your API credentials, which should allow access for 60 minutes.
}
\examples{
\dontrun{
cp_token <- calpass_get_token(username='my_cp_api_uid', password='my_cp_api_pwd'
  , client_id='my_client_id'
  , scope='my_scope'
  )
}
}
\references{
\href{https://mmap.calpassplus.org/Documentation/Authentication}{MMAP API V1: Getting An Access Token Using User Credentials}
}
\author{
Vinh Nguyen
}
