% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r-session.R
\name{r_session}
\alias{r_session}
\title{External R Session}
\description{
A permanent R session that runs in the background. This is an R6 class
that extends the \link[processx:process]{processx::process} class.
}
\details{
The process is started at the creation of the object, and then it can
be used to evaluate R function calls, one at a time.
}
\section{Usage}{
\preformatted{rs <- r_session$new(options = r_session_options(), wait = TRUE,
                     wait_timeout = 3000)

rs$run(func, args = list())
rs$run_with_output(func, args = list())
rs$call(func, args = list())

rs$poll_process(timeout)

rs$get_state()
rs$get_running_time()

rs$read()
rs$close(grace = 1000)

rs$traceback()
}
}

\section{Arguments}{

\itemize{
\item \code{options}: A list of options created via \code{\link[=r_session_options]{r_session_options()}}.
\item \code{wait}: Whether to wait for the R process to start and be ready
for running commands.
\item \code{wait_timeout}: Timeout for waiting for the R process to start,
in milliseconds.
\item \code{func}: Function object to call in the background R process.
Please read the notes for the similar argument of \code{\link[=r]{r()}}
\item \code{args}: Arguments to pass to the function. Must be a list.
\item \code{timeout}: Timeout period in milliseconds.
\item \code{grace}: Grace period in milliseconds, to wait for the subprocess to
exit cleanly, after its standard input is closed. If the process is
still running after this period, it will be killed.
}
}

\section{Details}{

\code{r_session$new()} creates a new R background process. It can wait for the
process to start up (\code{wait = TRUE}), or return immediately, i.e. before
the process is actually ready to run. In the latter case you may call
\code{rs$poll_process()} to make sure it is ready.

\code{rs$run()} is similar to \code{\link[=r]{r()}}, but runs the function in the \code{rs} R
session. It throws an error if the function call generated an error in
the child process.

\code{rs$run_with_output()} is similar to \code{$run()}, but returns the standard
output and error of the child process as well. It does not throw on
errors, but returns a non-zero \code{error} member in the result list.

\code{rs$call()} starts running a function in the background R session, and
returns immediately. To check if the function is done, call the
\code{poll_process()} method.

\code{rs$poll_process()} polls the R session with a timeout. If the session
has finished the computation, it returns with \code{"ready"}. If the timeout
is reached, it returns with \code{"timeout"}.

\code{rs$get_state()} return the state of the R session. Possible values:
\itemize{
\item \code{"starting"}: starting up,
\item \code{"idle"}: ready to compute,
\item \code{"busy"}: computing right now,
\item \code{"finished"}: the R process has finished.
}

\code{rs$get_running_time()} returns the elapsed time since the R process
has started, and the elapsed time since the current computation has
started. The latter is NA if there is no active computation.

\code{rs$read()} reads an event from the child process, if there is one
available. Events might signal that the function call has finished,
or they can be progress report events.

\code{rs$close()} terminates the current computation and the R process.
The session object will be in \code{"finished"} state after this.

`rs$traceback() can be used after an error in the R subprocess. It is
equivalent to the \code{\link[=traceback]{traceback()}} call, but it is performed in the
subprocess.
}

\examples{
\dontrun{
rs <- r_ression$new()

rs$run(function() 1 + 2)

rs$call(function() Sys.sleep(1))
rs$get_state()

rs$poll_process(-1)
rs$get_state()
rs$read()
}
}
