% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pdf.R
\name{plot_pdf}
\alias{plot_pdf}
\title{plot_pdf}
\usage{
plot_pdf(fire_index, thresholds, upper_limit = NULL, v_lines = NULL)
}
\arguments{
\item{fire_index}{RasterBrick containing the fire index}

\item{thresholds}{thresholds calculated using the function
\code{get_fire_danger_levels()}}

\item{upper_limit}{FWI upper limit to visualise
(the default is the maximum FWI)}

\item{v_lines}{named vector of values to plot as vertical lines
(this can be quantiles for comparison)}
}
\description{
Plot PDF of fire index
}
\examples{
\dontrun{
  r <- readRDS(system.file("extdata", "RISICO_raster.rds", package = "caliver"))
  plot_pdf(r, thresholds = c(5.2, 11.2, 21.3, 38, 50))
}

}
