% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_calib.R
\name{plot.calib_pv}
\alias{plot.calib_pv}
\title{Plots calibration curves estimated using \code{\link{calib_pv}}.}
\usage{
\method{plot}{calib_pv}(x, ..., combine = TRUE, ncol = NULL, nrow = NULL, transparency.rug = 0.1)
}
\arguments{
\item{x}{Object of class 'calib_pseudo' generated from \code{\link{calib_pv}}.}

\item{...}{Other}

\item{combine}{Whether to combine into one plot using ggarrange, or return as a list of individual plots}

\item{ncol}{Number of columns for combined calibration plot}

\item{nrow}{Number of rows for combined calibration plot}

\item{transparency.rug}{Degree of transparency for the density rug plot along each axis}
}
\value{
If \code{combine = TRUE}, returns an object of classes \code{gg}, \code{ggplot}, and \code{ggarrange},
as all ggplots have been combined into one object. If \code{combine = FALSE}, returns an object of
class \code{list}, each element containing an object of class \code{gg} and \code{ggplot}.
}
\description{
Plots calibration curves for the transition probabilities of a multistate model
estimated using \code{\link{calib_pv}}.
}
\examples{
# Using competing risks data out of initial state (see vignette: ... -in-competing-risk-setting).
# Estimate and plot pseudo-value calibration curves for the predicted transition
# probabilities at time t = 1826, when predictions were made at time
# s = 0 in state j = 1. These predicted transition probabilities are stored in tp.cmprsk.j0.

# To minimise example time we reduce the datasets to 50 individuals.
# Extract the predicted transition probabilities out of state j = 1 for first 50 individuals
tp.pred <- tp.cmprsk.j0 |>
 dplyr::filter(id \%in\% 1:50) |>
 dplyr::select(any_of(paste("pstate", 1:6, sep = "")))
# Reduce ebmtcal to first 50 individuals
ebmtcal <- ebmtcal |> dplyr::filter(id \%in\% 1:50)
# Reduce msebmtcal.cmprsk to first 50 individuals
msebmtcal.cmprsk <- msebmtcal.cmprsk |> dplyr::filter(id \%in\% 1:50)

# Now estimate the observed event probabilities for each possible transition.
dat.calib.pv <- calib_pv(data.mstate = msebmtcal.cmprsk,
  data.raw = ebmtcal,
  j = 1,
  s = 0,
  t = 1826,
  tp.pred = tp.pred,
  curve.type = "loess",
  loess.span = 1,
  loess.degree = 1)

 # These are then plotted
 plot(dat.calib.pv, combine = TRUE, nrow = 2, ncol = 3)

}
