% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{index}
\alias{index}
\alias{index<-}
\title{Tensor Indices}
\usage{
index(x)

index(x) <- value
}
\arguments{
\item{x}{\code{array}.}

\item{value}{vector of indices.}
}
\value{
Vector of indices.
}
\description{
Functions to get or set the names of the dimensions of an \code{array}.
}
\section{Functions}{
\itemize{
\item \code{index(x) <- value}: set indices.

}}
\examples{
### array with no indices
x <- array(1, dim = c(1, 3, 2))
index(x)

### indices on initialization
x <- array(1, dim = c(i=1, j=3, k=2))
index(x)

### set indices on the fly
x <- array(1, dim = c(1, 3, 2))
index(x) <- c("i", "j", "k")
index(x)

}
\references{
Guidotti, E. (2020). "calculus: High dimensional numerical and symbolic calculus in R". \url{https://arxiv.org/abs/2101.00086}
}
\seealso{
Other tensor algebra: 
\code{\link{contraction}()},
\code{\link{delta}()},
\code{\link{diagonal}()},
\code{\link{einstein}()},
\code{\link{epsilon}()}
}
\concept{tensor algebra}
