% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{cross}
\alias{cross}
\alias{\%cross\%}
\title{Numerical and Symbolic Cross Product}
\usage{
cross(...)

x \%cross\% y
}
\arguments{
\item{...}{\eqn{n-1} vectors of length \eqn{n}.}

\item{x}{\code{numeric} or \code{character} vector of length 3.}

\item{y}{\code{numeric} or \code{character} vector of length 3.}
}
\value{
\eqn{n}-dimensional vector orthogonal to the \eqn{n-1} vectors.
}
\description{
Computes the cross product of \eqn{n-1} vectors of length \eqn{n}.
}
\section{Functions}{
\itemize{
\item \code{\%cross\%}: binary operator for 3-dimensional cross products.
}}

\examples{
### canonical basis 4-d
cross(c(1,0,0,0), c(0,1,0,0), c(0,0,0,1))

### canonical basis 3-d
cross(c(1,0,0), c(0,1,0))

### symbolic cross product 3-d
c(1,0,0) \%cross\% c(0,1,0)

### symbolic cross product 3-d
c("a","b","c") \%cross\% c(0,0,1)

}
\references{
Guidotti, E. (2020). "calculus: High dimensional numerical and symbolic calculus in R". \url{https://arxiv.org/abs/2101.00086}
}
\concept{vector algebra}
