% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineclassesandfunctions.R
\name{allvarscovs}
\alias{allvarscovs}
\title{Extract all variances and covariances in readable form as a data frame}
\usage{
allvarscovs(x, thing = "columns")
}
\arguments{
\item{x}{An object of class \code{\linkS4class{cabootcrsresults}}}

\item{thing}{Whether to extract the variances for
\describe{
\item{"rows"}{rows, or}
\item{"columns"}{columns}
}
Note that default is "columns" as this is more convenient for MCA}
}
\value{
A data frame with one row for each row or column category
}
\description{
\code{allvarscovs} extracts all variances and covariances for either rows or columns
and puts them in a data frame
}
\examples{
results <- cabootcrs(DreamData, showresults=FALSE)
rowvars <- allvarscovs(results,"rows")
colvars <- allvarscovs(results,"columns")

\dontrun{

resultsmca <- cabootcrs(DreamData223by3, catype="mca", showresults=FALSE)
allvars <- allvarscovs(resultsmca)

}

}
\seealso{
\code{\link{cabootcrs-package}}, \code{\link{cabootcrs}},
\code{\link{covmat}}, \code{\linkS4class{cabootcrsresults}}
}
